<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'url' => 'dashboard.settings.languages.index',
        'text' => t__('Languages')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $language['name']]),
    'category' => 'settings.languages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $language['name']]) ?>
        </h1>
		    <div class="flex gap-2">
	        <a href="https://github.com/leaderos-net/translate" target="_blank" class="btn btn-primary">
		        <?php e__('Contribute') ?>
	        </a>
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/languages" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.languages.index') ?>" class="btn btn-default">
		        <?php e__('Back') ?>
	        </a>
        </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.settings.languages.update', ['id' => $language["code"]]) ?>" method="post" class="grid gap-4 mt-10">
    <div class="card p-6 grid gap-4">
            <?php _method('PATCH'); ?>
            <div>
                <label for="languageCode" class="form-label">
                    <?php e__('Language Code') ?>
                </label>
                <input value="<?php echo $language['code']; ?>" type="text" id="languageCode" class="form-control" disabled>
            </div>
            <div>
                <label for="languageName" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('languageName', $language['name']) ?>" type="text" id="languageName" name="languageName" class="form-control" required>
            </div>
        </div>
		    <?php if (file_exists($languageFile)): ?>
		      <div class="card pt-4 pb-2 px-6 grid gap-4">
				    <?php $languageContent = json_decode(file_get_contents($languageFile), true); ?>
				    <div>
					    <div class="py-2 border-b rounded-t-lg bg-los-deep/40 border-gray-600/10 grid grid-cols-2 gap-4 text-xs font-medium">
						    <div class="text-gray-500 px-3">
							    <?php e__('Source') ?>
						    </div>
						    <div class="text-gray-500 px-3">
							    <?php e__('Translation') ?>
						    </div>
					    </div>
					    <div class="grid gap-4 mt-4">
						    <?php foreach ($languageContent as $key => $value): ?>
							    <div class="grid grid-cols-2 items-center gap-4">
								    <div class="text-gray-800 text-sm">
									    <?php echo $key; ?>
								    </div>
								    <div>
									    <?php $findCustomTranslate = array_filter($customTranslateArray, fn($item) => $item['key'] == $key); ?>
									    <textarea name="languageKeys[]" class="form-control" required style="display: none;"><?php echo $key ?></textarea>
									    <textarea name="languageValues[]" class="form-control" required><?php echo count($findCustomTranslate) ? array_values($findCustomTranslate)[0]['value'] : $value; ?></textarea>
								    </div>
							    </div>
						    <?php endforeach; ?>
						    
						    <?php if (file_exists($themeLanguageFile)): ?>
							    <?php $themeLanguageContent = json_decode(file_get_contents($themeLanguageFile), true); ?>
							    <?php foreach ($themeLanguageContent as $key => $value): ?>
								    <div class="grid grid-cols-2 items-center gap-4">
									    <div class="text-gray-800">
										    <?php echo $key; ?>
									    </div>
									    <div>
										    <?php $findCustomTranslate = array_filter($customTranslateArray, fn($item) => $item['key'] == $key); ?>
										    <textarea name="theme_languageKeys[]" class="form-control" required style="display: none;"><?php echo $key ?></textarea>
										    <textarea name="theme_languageValues[]" class="form-control" required><?php echo count($findCustomTranslate) ? array_values($findCustomTranslate)[0]['value'] : $value; ?></textarea>
									    </div>
								    </div>
							    <?php endforeach; ?>
						    <?php endif; ?>
					    </div>
				    </div>
				    <div class="flex justify-end sticky bottom-0 py-4 card !rounded-none !border-b-0 !border-l-0 !border-r-0">
					    <?php _csrf(); ?>
					    <button type="submit" class="btn btn-success">
						    <?php e__('Save Changes') ?>
					    </button>
				    </div>
		      </div>
		    <?php endif; ?>
    </form>
</section>

