<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('Languages')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Languages'),
    'category' => 'settings.languages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Languages') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/languages" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.languages.create') ?>" class="btn btn-primary">
	            <?php e__('Add New') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>
	
		<div x-data="listjs()" id="listjs" class="grid mt-10">
			<div class="los-table-actions mb-4 grid">
				<div class="w-full">
					<label for="search" class="form-label">
						<?php e__('Search for %text%', ['%text%' => t__('Languages')]) ?>
					</label>
					<div class="input-absolute-group">
						<i data-feather="search-normal"></i>
						<input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					</div>
				</div>
			</div>
			<div class="los-table">
				<table>
					<thead>
					<tr>
						<th>
							<div class="sort" data-sort="name">
								<?php e__('Name') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="code">
								<?php e__('Code') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="status">
								<?php e__('Status') ?>
							</div>
						</th>
						<th>
							<span class="sr-only">
								<?php e__('Actions') ?>
							</span>
						</th>
					</tr>
					</thead>
					<tbody class="list">
					<?php foreach ($languages as $language): ?>
						<tr>
							<td>
								<a href="<?php echo url('dashboard.settings.languages.edit', ['id' => $language['code']]) ?>" class="name">
									<?php echo $language['name'] ?>
								</a>
								<?php if (settings('language') == $language["code"]): ?>
									<div class="badge badge-sm badge-primary ml-1">
										<?php e__('Default') ?>
									</div>
								<?php else: ?>
									<?php if ($language['isActive'] == 1): ?>
										<form action="<?php echo url('dashboard.settings.languages.set', ['id' => $language['code']]) ?>" method="post" class="block text-xs text-gray-500 hover:!text-blue-500">
											<?php _method('PATCH'); ?>
											<?php _csrf(); ?>
											<button type="submit" class="!text-left">
												<?php e__('Set as default') ?>
											</button>
										</form>
									<?php endif; ?>
								<?php endif; ?>
							</td>
							<td class="code">
								<?php echo strtoupper($language['code']) ?>
							</td>
							<td class="status not">
								<?php if ($language['isActive'] == 1): ?>
									<span class="badge badge-soft-success"><?php e__('Enabled') ?></span>
								<?php else: ?>
									<span class="badge badge-soft-danger"><?php e__('Disabled') ?></span>
								<?php endif; ?>
							</td>
							<td>
								<div class="flex justify-end items-center">
									<a href="<?php echo url('dashboard.settings.languages.edit', ['id' => $language['code']]) ?>" class="btn btn-sm link-primary">
										<?php e__('Translate') ?>
									</a>
									<?php if (settings('language') != $language["code"]): ?>
										<form action="<?php echo url('dashboard.settings.languages.toggle', ['id' => $language['code']]) ?>" method="post">
											<?php _csrf(); ?>
											<?php if ($language['isActive'] == 1): ?>
												<button type="submit" class="btn btn-sm link-danger">
													<?php e__('Disable') ?>
												</button>
											<?php else: ?>
												<button type="submit" class="btn btn-sm link-success">
													<?php e__('Enable') ?>
												</button>
											<?php endif; ?>
										</form>
									<?php endif; ?>
								</div>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
</section>
