<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.settings.index',
    'text' => t__('Settings')
  ],
  [
    'text' => t__('Paraşüt')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('Paraşüt Settings'),
  'category' => 'settings.parasut',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950"><?php e__('Paraşüt Settings') ?></h1>
    <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <?php _message(); ?>

  <form action="<?php echo url('dashboard.settings.parasut.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4" x-data="{authType: '<?php _old('authType', moduleSettings('parasut', 'authType')); ?>'}">
    <?php _method('PATCH'); ?>
    <div class="mt-10 card p-6 grid gap-4">
      <div>
        <label for="clientID" class="form-label"><?php e__('Client ID') ?>:</label>
        <div>
          <input type="text" id="clientID" class="form-control" name="clientID" value="<?php _old('clientID', moduleSettings('parasut', 'clientID')); ?>">
        </div>
      </div>
      <div>
        <label for="clientSecret" class="form-label"><?php e__('Client Secret') ?>:</label>
        <div>
          <input type="text" id="clientSecret" class="form-control" name="clientSecret" value="<?php _old('clientSecret', moduleSettings('parasut', 'clientSecret')); ?>">
        </div>
      </div>
      <div>
        <label for="companyID" class="form-label">Firma ID:</label>
        <div>
          <input type="text" id="companyID" class="form-control" name="companyID" value="<?php _old('companyID', moduleSettings('parasut', 'companyID')); ?>">
        </div>
      </div>
      <div>
        <label for="accountID" class="form-label">Kasa/Banka ID:</label>
        <div>
          <input type="text" id="accountID" class="form-control" name="accountID" value="<?php _old('accountID', moduleSettings('parasut', 'accountID')); ?>">
        </div>
      </div>
	    <div>
		    <label for="productID" class="form-label">Ürün ID:</label>
		    <div>
			    <input type="text" id="productID" class="form-control" name="productID" value="<?php _old('productID', moduleSettings('parasut', 'productID')); ?>">
		    </div>
	    </div>
      <div>
        <label for="authType" class="form-label">Doğrulama Türü:</label>
        <div>
          <select x-data="select2Alpine()" name="authType" id="authType" x-init="changed('authType', () => authType = selected)">
            <option value="1" <?php _selected(old('authType', moduleSettings('parasut', 'authType')) == '1'); ?>>
              <?php e__('Email-Password') ?>
            </option>
            <option value="2" <?php _selected(old('authType', moduleSettings('parasut', 'authType')) == '2'); ?>>
              <?php e__('OAuth') ?>
            </option>
          </select>
        </div>
      </div>
      <div x-show="authType === '1'">
        <label for="username" class="form-label"><?php e__('Email') ?>:</label>
        <div>
          <input type="text" id="username" class="form-control" name="username" value="<?php _old('username', moduleSettings('parasut', 'username')); ?>">
        </div>
      </div>
      <div x-show="authType === '1'">
        <label for="password" class="form-label"><?php e__('Password') ?>:</label>
        <div>
          <input type="text" id="password" class="form-control" name="password" value="<?php _old('password', moduleSettings('parasut', 'password')); ?>">
        </div>
      </div>
      <div>
        <label for="isDevelopment" class="form-label"><?php e__('Development Mode') ?>:</label>
        <div>
          <select x-data="select2Alpine()" name="isDevelopment" id="isDevelopment">
            <option value="0" <?php _selected(old('isDevelopment', moduleSettings('parasut', 'isDevelopment')) == '0'); ?>>
              <?php e__('Disable') ?>
            </option>
            <option value="1" <?php _selected(old('isDevelopment', moduleSettings('parasut', 'isDevelopment')) == '1'); ?>>
              <?php e__('Enable') ?>
            </option>
          </select>
        </div>
      </div>
    </div>
    <div class="flex justify-end">
      <?php _csrf(); ?>
      <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
    </div>
  </form>
</section>