<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('Punishments')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Punishment Settings'),
    'category' => 'settings.punishments',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="border-b border-gray-600/10 pb-10 flex justify-between items-center">
        <h1 class="text-gray-950"><?php e__('Punishment Settings') ?></h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/punishments" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.settings.punishments.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
        <?php _method('PATCH'); ?>
        <div class="mt-12 card p-6 grid gap-4">
            <div>
                <label for="plugin" class="form-label"><?php e__('Plugin') ?>:</label>
                <div>
                  <select x-data="select2Alpine()" name="plugin" id="plugin">
                    <option value="litebans" <?php _selected(old('plugin', moduleSettings('punishments', 'plugin')) == 'litebans'); ?>>
                      Litebans
                    </option>
                    <option value="advancedban" <?php _selected(old('plugin', moduleSettings('punishments', 'plugin')) == 'advancedban'); ?>>
                      AdvancedBan
                    </option>
                  </select>
                </div>
            </div>
          <div x-data="{mysqlServerStatus: '<?php _old('mysqlServerStatus', moduleSettings('punishments', 'mysqlHost') == '' ? '0' : '1') ?>'}">
            <div>
              <label for="mysqlServerStatus" class="form-label">
                <?php e__('MySQL Connection') ?>
              </label>
              <select x-data="select2Alpine()" x-init="changed('select',() => mysqlServerStatus=selected)" name="mysqlServerStatus" id="mysqlServerStatus" required>
                <option value="0" <?php _selected(old('mysqlServerStatus', moduleSettings('punishments', 'mysqlHost') == "" ? "0" : "1") == 0); ?>>
                  <?php e__('Connect this server') ?>
                </option>
                <option value="1" <?php _selected(old('mysqlServerStatus', moduleSettings('punishments', 'mysqlHost') == "" ? "0" : "1") != 0); ?>>
                  <?php e__('Connect another server') ?>
                </option>
              </select>
            </div>

            <div x-show="mysqlServerStatus === '1'" class="flex flex-col gap-4 mt-4">
              <div class="grid lg:grid-cols-2 gap-4">
                <div>
                  <label for="mysqlHost" class="form-label">
                    <?php e__('MySQL Host') ?>
                  </label>
                  <input value="<?php _old('mysqlHost', moduleSettings('punishments', 'mysqlHost')) ?>" id="mysqlHost" type="text" name="mysqlHost" class="form-control">
                </div>
                <div>
                  <label for="mysqlPort" class="form-label">
                    <?php e__('MySQL Port') ?>
                  </label>
                  <input value="<?php _old('mysqlPort', moduleSettings('punishments', 'mysqlPort')) ?>" id="mysqlPort" type="text" name="mysqlPort" class="form-control">
                </div>
                <div>
                  <label for="mysqlUsername" class="form-label">
                    <?php e__('MySQL Username') ?>
                  </label>
                  <input value="<?php _old('mysqlUsername', moduleSettings('punishments', 'mysqlUsername')) ?>" id="mysqlUsername" type="text" name="mysqlUsername" class="form-control">
                </div>
                <div>
                  <label for="mysqlPassword" class="form-label">
                    <?php e__('MySQL Password') ?>
                  </label>
                  <input value="<?php _old('mysqlPassword', moduleSettings('punishments', 'mysqlPassword')) ?>" id="mysqlPassword" type="text" name="mysqlPassword" class="form-control">
                </div>
              </div>
              <div>
                <label for="mysqlDatabase" class="form-label">
                  <?php e__('MySQL Database') ?>
                </label>
                <input value="<?php _old('mysqlDatabase', moduleSettings('punishments', 'mysqlDatabase')) ?>" id="mysqlDatabase" type="text" name="mysqlDatabase" class="form-control">
              </div>
              <div class="mb-4">
                <button type="button" @click="checkSqlConnection()" class="btn btn-default flex items-center">
                  <svg style="display: none;" class="animate-spin -ml-1 mr-3 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                  </svg>
                  <span>
                    <?php e__('Check Database Connection') ?>
                  </span>
                </button>
              </div>
            </div>
          </div>
          <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
          </div>
        </div>
    </form>
</section>