<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.settings.index',
    'text' => t__('Settings')
  ],
  [
    'text' => t__('Cloudflare Turnstile')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('%module% Settings', ['%module%' => t__('Cloudflare Turnstile')]),
  'category' => 'settings.recaptcha',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950"><?php e__('%module% Settings', ['%module%' => t__('Cloudflare Turnstile')]) ?></h1>
    <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <?php _message(); ?>

  <form action="<?php echo url('dashboard.settings.recaptcha.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
    <?php _method('PATCH'); ?>
    <div
		    class="mt-10 card p-6 grid gap-4"
		    x-data="{
		      publicKey: '<?php _old('publicKey', moduleSettings('recaptcha', 'publicKey') != '0' ? moduleSettings('recaptcha', 'publicKey') : '') ?>',
		      privateKey: '<?php _old('privateKey', moduleSettings('recaptcha', 'privateKey') != '0' ? moduleSettings('recaptcha', 'privateKey') : '') ?>',
		    }"
    >
	    <div>
		    <label for="publicKey" class="form-label">Site Key:</label>
		    <div>
			    <input type="text" id="publicKey" class="form-control" name="publicKey" x-model="publicKey">
		    </div>
	    </div>
	    <div>
		    <label for="privateKey" class="form-label">Secret Key:</label>
		    <div>
			    <input type="text" id="privateKey" class="form-control" name="privateKey" x-model="privateKey">
		    </div>
	    </div>
	    <div x-show="publicKey != '' && privateKey != ''">
		    <label for="pagesStatus" class="form-label"><?php e__('Active Pages') ?>:</label>
		    <div class="flex flex-col gap-2 mb-3">
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["login"],
					    'labelRight' => t__('Login')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["register"],
					    'labelRight' => t__('Register')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["forgot_password"],
					    'labelRight' => t__('Recover Password')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["reply_blog_post"],
					    'labelRight' => t__('Reply Blog Post')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["open_ticket"],
					    'labelRight' => t__('Open Ticket')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["reply_ticket"],
					    'labelRight' => t__('Reply Ticket')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["tfa"],
					    'labelRight' => t__('2FA')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["post_thread"],
					    'labelRight' => t__('Post Thread')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["reply_thread"],
					    'labelRight' => t__('Reply Thread')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["post_suggestion"],
					    'labelRight' => t__('Post Suggestion')
				    ]); ?>
			    </div>
			    <div class="flex gap-2">
				    <?php $this->insert('components/toggle', [
					    'name' => 'pagesStatus[]',
					    'default' => $recaptchaPagesStatus["reply_suggestion"],
					    'labelRight' => t__('Reply Suggestion')
				    ]); ?>
			    </div>
		    </div>
	    </div>
    </div>
    <div class="flex justify-end">
      <?php _csrf(); ?>
      <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
    </div>
  </form>
</section>