<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('SEO')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('SEO Settings'),
    'category' => 'settings.seo',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tighter-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('SEO Settings') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/seo" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="grid lg:grid-cols-10 gap-4 mt-10">
        <div class="lg:col-span-3">
            <div class="card tab-container">
                <div class="px-4" style="max-height: 700px;overflow-y: auto">
                    <?php foreach ($seoPages as $seoPageData): ?>
                        <a href="?tab=<?php echo $seoPageData["page"]; ?>" class="tab-item block <?php echo $seoPage["page"] == $seoPageData["page"] ? 'active' : null ?>">
                            <?php e__("seo_" . $seoPageData["page"]); ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <div class="lg:col-span-7">
            <div class="card py-4 px-6">
                <form action="<?php echo url('dashboard.settings.seo.update', ['id' => $seoPage['id']]) ?>" method="post">
                    <?php _method('PATCH'); ?>
                    <div class="divide-y divide-gray-600/10">
                        <div class="py-6">
                            <label class="col-span-2" for="title">
                    <span class="font-medium text-gray-700">
                      <?php e__('Title') ?>
                    </span>
                                <p class="mt-1 text-gray-400/75 text-sm max-w-md">
                                    <?php e__('The title of the page that will be displayed in the Google search results.') ?>
                                </p>
                            </label>
                            <div class="mt-3 flex flex-col justify-center">
                                <input name="title" id="title" class="form-control" type="text" value="<?php _old('title', $seoPage['title']) ?>">
                            </div>
                        </div>
                        <div class="py-6">
                            <label class="col-span-2" for="description">
                    <span class="font-medium text-gray-700">
                      <?php e__('Description') ?>
                      <span class="text-xs text-gray-400">(<?php e__('Optional') ?>)</span>
                    </span>
                                <p class="mt-1 text-gray-400/75 text-sm max-w-md">
                                    <?php e__('If you leave the description blank, the default value of "Google Description" will be used.') ?>
                                </p>
                            </label>
                            <div class="mt-3 flex flex-col justify-center">
                                <textarea class="form-control" name="description" id="description" cols="30" rows="7"><?php _old('description', $seoPage['description']) ?></textarea>
                            </div>
                        </div>
                        <div class="py-6">
                            <label class="col-span-2" for="image">
                    <span class="font-medium text-gray-700">
                      <?php e__('Image') ?>
                      <span class="text-xs text-gray-400">(<?php e__('Optional') ?>)</span>
                    </span>
                                <p class="mt-1 text-gray-400/75 text-sm max-w-md">
                                    <?php e__('The Image that will be displayed in embeds, social media, etc.') ?>
                                </p>
                            </label>
                            <div class="mt-3 flex flex-col justify-center">
                                <input name="image" id="image" value="<?php _old('image', $seoPage['image']) ?>" class="form-control" type="text">
                            </div>
                        </div>
                    </div>
                    <div class="flex justify-end mt-10">
                        <?php _csrf(); ?>
                        <button type="submit" class="btn btn-success">
                            <?php e__('Save Changes') ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
