<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('SMTP')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('SMTP Settings'),
    'category' => 'settings.smtp',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.10.7/tinymce.min.js" referrerpolicy="origin"></script>
<script>
    tinymce.init({
        selector: '.email-template-editor',
        <?php if ($lang != "en"): ?>
        language_url : '<?php echo "/apps/dashboard/public/assets/js/tinymce/langs/$lang.js"; ?>',
        language: '<?php echo $lang; ?>',
        <?php endif; ?>
        plugins: 'code link image fullscreen preview fullpage autosave',
        toolbar: 'formatselect | bold italic underline strikethrough backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | image  fullscreen preview code',
        menubar: '',
        content_style: 'table:not([cellpadding]) td,table:not([cellpadding]) th {padding: 0;}',
        elementpath: false,
    });
</script>
<?php $this->end(); ?>
<style>
    .tox-tinymce {
        min-height: 500px !important;
    }
</style>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('SMTP Settings') ?></h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/settings/smtp" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
		      <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
			      <?php e__('Back') ?>
		      </a>
	      </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.settings.smtp.update') ?>" method="post" enctype="multipart/form-data">
        <?php _method('PATCH'); ?>
        <div class="mt-10 card p-6 grid gap-4">
            <div>
                <label for="inputSMTPServer" class="form-label"><?php e__('SMTP Server') ?>:</label>
                <div>
                    <input type="text" id="inputSMTPServer" class="form-control" name="smtpServer" value="<?php _old('smtpServer', settings('smtpServer')) ?>" required>
                </div>
            </div>
            <div>
                <label for="inputSMTPPort" class="form-label"><?php e__('SMTP Port') ?>:</label>
                <div>
                    <input type="number" id="inputSMTPPort" class="form-control" name="smtpPort" value="<?php _old('smtpPort', settings('smtpPort')) ?>" required>
                </div>
            </div>

            <div>
                <label for="selectSMTPSecure" class="form-label"><?php e__('SMTP Security') ?>:</label>
                <select x-data="select2Alpine()" name="smtpSecure" id="selectSMTPSecure">
                    <option value="1" <?php _selected(old('smtpSecure', settings('smtpSecure')) == '1'); ?>>
                        SSL
                    </option>
                    <option value="2" <?php _selected(old('smtpSecure', settings('smtpSecure')) == '2'); ?>>
                        TLS
                    </option>
                </select>
            </div>
		        <div>
			        <label for="inputSMTPSenderEmail" class="form-label"><?php e__('SMTP Sender Email Address') ?>:</label>
			        <div>
				        <input type="text" id="inputSMTPSenderEmail" class="form-control" name="smtpSenderEmail" value="<?php _old('smtpSenderEmail', settings('smtpSenderEmail')) ?>" required>
			        </div>
		        </div>
            <div>
                <label for="inputSMTPUsername" class="form-label"><?php e__('SMTP Username') ?>:</label>
                <div>
                    <input type="text" id="inputSMTPUsername" class="form-control" name="smtpUsername" value="<?php _old('smtpUsername', settings('smtpUsername')) ?>" required>
                </div>
            </div>
            <div>
                <label for="inputSMTPPassword" class="form-label"><?php e__('SMTP Password') ?>:</label>
                <div>
                    <input type="password" id="inputSMTPPassword" class="form-control" name="smtpPassword" value="<?php _old('smtpPassword', settings('smtpPassword')) ?>" required>
                </div>
            </div>
            <div>
                <button type="button" @click="checkSmtp()" class="btn btn-default flex items-center">
                    <svg style="display: none;" class="animate-spin -ml-1 mr-3 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <span>
                        <?php e__('Check Connection') ?>
                    </span>
                </button>
            </div>
		        <div class="flex justify-end">
		          <?php _csrf(); ?>
			        <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
		        </div>
        </div>
    </form>
</section>