<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.settings.index',
    'text' => t__('Settings')
  ],
  [
    'text' => t__('Store')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('%module% Settings', ['%module%' => t__('Store')]),
  'category' => 'settings.store',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950"><?php e__('%module% Settings', ['%module%' => t__('Store')]) ?></h1>
    <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <?php _message(); ?>

  <form action="<?php echo url('dashboard.settings.store.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
    <?php _method('PATCH'); ?>
    <div
		    class="mt-10 card p-6 grid gap-4"
		    x-data="{
			    taxStatus: <?php _old('taxStatus', moduleSettings('store', 'tax') == '0' ? 'false' : 'true') ?>,
			    storeRedirectionStatus: <?php _old('storeRedirectStatus', moduleSettings('store', 'redirect') == '' ? 'false' : 'true') ?>,
			    cashbackStatus: <?php _old('cashbackStatus', moduleSettings('store', 'cashback') == '0' ? 'false' : 'true') ?>,
	      }"
    >
	    <div>
		    <label for="minPay" class="form-label"><?php e__('Min. Payment Amount') ?>:</label>
		    <div>
			    <input type="text" id="minPay" class="form-control" name="minPay" value="<?php _old('minPay', moduleSettings('store', 'minPay')); ?>">
		    </div>
	    </div>
	    <div>
		    <label for="maxPay" class="form-label"><?php e__('Max Payment Amount') ?>:</label>
		    <div>
			    <input type="text" id="maxPay" class="form-control" name="maxPay" value="<?php _old('maxPay', moduleSettings('store', 'maxPay')); ?>">
		    </div>
	    </div>
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'taxStatus',
			    'default' => old('taxStatus', moduleSettings('store', 'tax')) == '0' ? '0' : '1',
			    'action' => 'taxStatus = !taxStatus',
			    'labelRight' => t__('Tax')
		    ]); ?>
	    </div>
      <div x-show="taxStatus">
        <label for="tax" class="form-label"><?php e__('Tax') ?> (%):</label>
        <div>
          <input type="text" id="tax" class="form-control" name="tax" value="<?php _old('tax', moduleSettings('store', 'tax') == '0' ? '' : moduleSettings('store', 'tax')); ?>">
        </div>
      </div>
	    
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'cashbackStatus',
			    'default' => old('cashbackStatus', moduleSettings('store', 'cashback')) == '0' ? '0' : '1',
			    'action' => 'cashbackStatus = !cashbackStatus',
			    'labelRight' => t__('Cashback')
		    ]); ?>
	    </div>
	    <div x-show="cashbackStatus">
		    <label for="cashback" class="form-label"><?php e__('Cashback') ?> (%):</label>
		    <div>
			    <input type="text" id="cashback" class="form-control" name="cashback" value="<?php _old('cashback', moduleSettings('store', 'cashback') == '0' ? '' : moduleSettings('store', 'cashback')); ?>">
		    </div>
	    </div>
	    
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'storeRedirectionStatus',
			    'default' => old('storeRedirectionStatus', moduleSettings('store', 'redirect')) == '' ? '0' : '1',
					'action' => 'storeRedirectionStatus = !storeRedirectionStatus',
			    'labelRight' => t__('Store Redirection')
		    ]); ?>
	    </div>
	    <div x-show="storeRedirectionStatus">
		    <label for="redirect" class="form-label"><?php e__('Store Redirect URL') ?>:</label>
		    <div>
			    <input type="text" id="redirect" class="form-control" name="redirect" value="<?php _old('redirect', moduleSettings('store', 'redirect')) ?>">
		    </div>
	    </div>
	    
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'showTermsCheckbox',
			    'default' => old('showTermsCheckbox', moduleSettings('store', 'showTermsCheckbox')) == '0' ? '0' : '1',
			    'labelRight' => t__('Show Terms Checkbox in Checkout')
		    ]); ?>
	    </div>
	    
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'removeMoneyZeroDecimal',
			    'default' => old('removeMoneyZeroDecimal', moduleSettings('store', 'removeMoneyZeroDecimal')) == '0' ? '0' : '1',
			    'labelRight' => t__('Remove .00 from money')
		    ]); ?>
	    </div>
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'isCreditRequiredOnPurchase',
			    'default' => old('isCreditRequiredOnPurchase', moduleSettings('store', 'isCreditRequiredOnPurchase')) == '0' ? '0' : '1',
			    'labelRight' => t__('Only allow purchases with Credits')
		    ]); ?>
	    </div>
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'topSalesStatus',
			    'default' => old('topSalesStatus', moduleSettings('store', 'topSalesStatus')) == '0' ? '0' : '1',
			    'labelRight' => t__('Bestseller')
		    ]); ?>
	    </div>
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'featuredProducts',
			    'default' => old('featuredProducts', moduleSettings('store', 'featuredProducts')) == '0' ? '0' : '1',
			    'labelRight' => t__('Featured Products')
		    ]); ?>
	    </div>
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'sendEmailOnPurchase',
			    'default' => old('sendEmailOnPurchase', moduleSettings('store', 'sendEmailOnPurchase')) == '0' ? '0' : '1',
			    'labelRight' => t__('Send an email to the customer after they complete the purchase')
		    ]); ?>
	    </div>
    </div>
    <div class="flex justify-end">
      <?php _csrf(); ?>
      <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
    </div>
  </form>
</section>