<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.settings.index',
    'text' => t__('Settings')
  ],
  [
    'text' => t__('Support')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('%module% Settings', ['%module%' => t__('Support')]),
  'category' => 'settings.support',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950"><?php e__('%module% Settings', ['%module%' => t__('Support')]) ?></h1>
    <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <?php _message(); ?>

  <form action="<?php echo url('dashboard.settings.support.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
    <?php _method('PATCH'); ?>
    <div class="mt-10 card p-6 grid gap-4">
	    <div>
		    <label for="ticketsLimit" class="form-label">
			    <?php e__('Maximum Active Support Tickets Allowed') ?>
		    </label>
		    <div class="input-group" data-toggle="unlimited-input" data-limit="<?php _old('ticketsLimit', moduleSettings('support', 'ticketsLimit')) ?>">
			    <div class="input-group-prepend">
				    <div class="input-group-text !bg-neutral-900">
					    <div class="flex gap-2 items-center">
						    <input
								    type="checkbox"
								    name="unlimitedTicketsLimit"
								    class="form-checkbox"
								    id="unlimitedTicketsLimit"
						    >
						    <label class="form-label select-none !mb-0" for="unlimitedTicketsLimit">
							    <?php e__('Unlimited') ?>
						    </label>
					    </div>
				    </div>
			    </div>
			    <input type="number" id="ticketsLimit" name="ticketsLimit" class="form-control">
		    </div>
	    </div>
	    <div x-data="textEditor()">
		    <label for="messageTemplate" class="form-label"><?php e__('Support Message Template') ?>:</label>
		    <div>
			    <div class="mt-2">
				    <textarea x-ref="textEditor" class="form-control" name="messageTemplate" id="messageTemplate"><?php echo moduleSettings('support', 'messageTemplate') ?></textarea>
			    </div>
			    <div class="grid gap-1 lg:grid-cols-3 mt-2">
				    <small class="text-gray-400/75"><strong><?php e__('Note') ?>:</strong> <?php e__('%message% is required') ?></small>
				    <small class="text-gray-400/75"><strong><?php e__('Message') ?>:</strong> %message%</small>
				    <small class="text-gray-400/75"><strong><?php e__('Username') ?>:</strong> %username%</small>
				    <small class="text-gray-400/75"><strong><?php e__('Server Name') ?>:</strong> %servername%</small>
				    <small class="text-gray-400/75"><strong><?php e__('Server IP') ?>:</strong> %serverip%</small>
			    </div>
		    </div>
	    </div>
	    <div>
		    <?php $this->insert('components/toggle', [
			    'name' => 'sendEmailOnAnswered',
			    'default' => old('sendEmailOnAnswered', moduleSettings('support', 'sendEmailOnAnswered')) == '0' ? '0' : '1',
			    'labelRight' => t__('Send an email to the user when their ticket is answered'),
		    ]); ?>
	    </div>
    </div>
    <div class="flex justify-end">
      <?php _csrf(); ?>
      <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
    </div>
  </form>
</section>