<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('System')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('System Settings'),
    'category' => 'settings.system',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('System Settings') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/system" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="mt-10 card p-6">
        <form action="<?php echo url('dashboard.settings.system.update') ?>" method="post" class="flex flex-col gap-4">
            <?php _method('PATCH'); ?>
            <div>
                <label for="selectTimezone" class="form-label"><?php e__('Timezone') ?>:</label>
                <div>
                    <select x-data="select2Alpine(true)" id="selectTimezone" class="form-control" name="timezone" data-toggle="select">
                        <?php
                        $zoneIdentifiers = timezone_identifiers_list();
                        $zoneLocations = array();

                        foreach ($zoneIdentifiers as $zoneIdentifier) {
                            $zone = explode('/', $zoneIdentifier);
                            $desiredRegions = array(
                                'Africa',
                                'America',
                                'Antarctica',
                                'Arctic',
                                'Asia',
                                'Atlantic',
                                'Australia',
                                'Europe',
                                'Indian',
                                'Pacific'
                            );
                            if (in_array($zone[0], $desiredRegions)) {
                                if (isset($zone[1]) != '') {
                                    $area = str_replace('_', ' ', $zone[1]);
                                    if (!empty($zone[2])) {
                                        $area = $area . ' (' . str_replace('_', ' ', $zone[2]) . ')';
                                    }
                                    $zoneLocations[$zone[0]][$zoneIdentifier] = $zone[0] . '/' . $area;
                                }
                            }
                        }

                        foreach ($zoneLocations as $zoneRegion => $regionAreas) {
                            foreach ($regionAreas as $regionArea => $zoneLabel) {
                                $currentTimeInZone = new DateTime("now", new DateTimeZone($regionArea));
                                $currentTimeDiff = $currentTimeInZone->format('P');
                                echo '<option value="' . $regionArea . '" ' . ($regionArea == settings("timezone") ? "selected" : null) . '>(GMT ' . $currentTimeDiff . ') ' . $zoneLabel . '</option>';
                            }
                        }
                        ?>
                    </select>
                </div>
            </div>
            <?php if (settings('gameType') == 'minecraft'): ?>
	            <div>
		            <label for="selectAvatarAPI" class="form-label">Avatar API:</label>
		            <div>
			            <select x-data="select2Alpine()" id="selectAvatarAPI" class="form-control" name="avatarAPI">
				            <option value="1" <?php echo (settings("avatarAPI") == 1) ? 'selected="selected"' : null; ?>>minotar.net (<?php e__('Recommended') ?>)</option>
				            <option value="2" <?php echo (settings("avatarAPI") == 2) ? 'selected="selected"' : null; ?>>cravatar.eu</option>
			            </select>
		            </div>
	            </div>
	            <div>
		            <label for="selectOnlineAPI" class="form-label">Online API:</label>
		            <div>
			            <select x-data="select2Alpine()" id="selectOnlineAPI" class="form-control" name="onlineAPI">
				            <option value="1" <?php echo (settings("onlineAPI") == 1) ? 'selected="selected"' : null; ?>>mcapi.us (<?php e__('Recommended') ?>)</option>
				            <option value="2" <?php echo (settings("onlineAPI") == 2) ? 'selected="selected"' : null; ?>>mc-api.net</option>
				            <option value="3" <?php echo (settings("onlineAPI") == 3) ? 'selected="selected"' : null; ?>>mcapi.tc</option>
				            <option value="4" <?php echo (settings("onlineAPI") == 4) ? 'selected="selected"' : null; ?>>keyubu.net</option>
				            <option value="5" <?php echo (settings("onlineAPI") == 5) ? 'selected="selected"' : null; ?>>mcsrvstat.us</option>
				            <option value="6" <?php echo (settings("onlineAPI") == 6) ? 'selected="selected"' : null; ?>>mcsrvstat.us (Pocket Edition)</option>
			            </select>
		            </div>
	            </div>
            <?php endif; ?>
            <div>
                <label for="selectPasswordType" class="form-label"><?php e__('Password Hashing') ?>:</label>
                <div>
                    <select x-data="select2Alpine()" id="selectPasswordType" class="form-control" name="passwordType">
                        <option value="1" <?php echo (settings("passwordType") == 1) ? 'selected="selected"' : null; ?>>SHA256</option>
                        <option value="2" <?php echo (settings("passwordType") == 2) ? 'selected="selected"' : null; ?>>MD5</option>
                        <option value="3" <?php echo (settings("passwordType") == 3) ? 'selected="selected"' : null; ?>>Bcrypt</option>
                    </select>
                </div>
            </div>
		        <div>
			        <label for="registerLimit" class="form-label">
				        <?php e__('Register Limit') ?>
			        </label>
			        <div class="input-group" data-toggle="unlimited-input" data-limit="<?php _old('registerLimit', settings('registerLimit')) ?>">
				        <div class="input-group-prepend">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
									        type="checkbox"
									        name="unlimitedRegisterLimit"
									        class="form-checkbox"
									        id="unlimitedRegisterLimit"
							        >
							        <label class="form-label select-none !mb-0" for="unlimitedRegisterLimit">
								        <?php e__('Unlimited') ?>
							        </label>
						        </div>
					        </div>
				        </div>
				        <input type="number" id="registerLimit" name="registerLimit" class="form-control">
			        </div>
		        </div>
		        <?php if (settings('loginProvider') == 'default'): ?>
			        <div>
				        <label for="usernameRegex" class="form-label"><?php e__('Username Validation Pattern') ?>:</label>
				        <div>
					        <input type="text" id="usernameRegex" class="form-control" name="usernameRegex" value="<?php _old('usernameRegex', settings('usernameRegex')) ?>">
				        </div>
				        <div class="form-text">
					        <?php e__('Enter a regular expression to define the allowed format for usernames.') ?>
				        </div>
			        </div>
		        <?php endif; ?>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'updateNotifications',
				        'default' => old('updateNotifications', settings('updateNotifications')) == '0' ? '0' : '1',
				        'labelRight' => t__('Update Notifications')
			        ]); ?>
		        </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'debugModeStatus',
				        'default' => old('debugModeStatus', settings('debugModeStatus')) == '0' ? '0' : '1',
				        'labelRight' => t__('Debug Mode')
			        ]); ?>
		        </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'sslStatus',
				        'default' => old('sslStatus', settings('sslStatus')) == '0' ? '0' : '1',
				        'labelRight' => t__('HTTPS Redirect')
			        ]); ?>
		        </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'maintenanceStatus',
				        'default' => old('maintenanceStatus', settings('maintenanceStatus')) == '0' ? '0' : '1',
				        'labelRight' => t__('Maintenance')
			        ]); ?>
		        </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'registrationStatus',
				        'default' => old('registrationStatus', settings('registrationStatus')) == '0' ? '0' : '1',
				        'labelRight' => t__('Registration')
			        ]); ?>
		        </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'forceDefaultLanguage',
				        'default' => old('forceDefaultLanguage', settings('forceDefaultLanguage')) == '0' ? '0' : '1',
				        'labelRight' => t__('Force Default Language')
			        ]); ?>
		        </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'emailChangeVerification',
				        'default' => old('emailChangeVerification', settings('emailChangeVerification')) == '0' ? '0' : '1',
				        'labelRight' => t__('Email Change Verification')
			        ]); ?>
		        </div>
		        <div>
			        <?php $this->insert('components/toggle', [
				        'name' => 'allowCustomAvatars',
				        'default' => old('allowCustomAvatars', settings('allowCustomAvatars')) == '0' ? '0' : '1',
				        'labelRight' => t__('Allow Custom Avatar Upload')
			        ]); ?>
		        </div>
            <?php _csrf(); ?>
            <div class="flex justify-end mt-4">
                <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
            </div>
        </form>
    </div>
</section>
