<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.settings.index',
    'text' => t__('Settings')
  ],
  [
    'text' => t__('Tawk.to')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('%module% Settings', ['%module%' => t__('Tawk.to')]),
  'category' => 'settings.tawkto',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950"><?php e__('%module% Settings', ['%module%' => t__('Tawk.to')]) ?></h1>
    <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <?php _message(); ?>

  <form action="<?php echo url('dashboard.settings.tawkto.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
    <?php _method('PATCH'); ?>
    <div class="mt-10 card p-6 grid gap-4">
      <div>
        <label for="id" class="form-label">Property ID:</label>
        <div>
          <input type="text" id="id" class="form-control" name="id" value="<?php _old('id', moduleSettings('tawkto', 'id')); ?>">
        </div>
      </div>
	    <div>
		    <label for="widgetID" class="form-label">Widget ID:</label>
		    <div>
			    <input type="text" id="widgetID" class="form-control" name="widgetID" value="<?php _old('widgetID', moduleSettings('tawkto', 'widgetID')); ?>">
		    </div>
	    </div>
    </div>
    <div class="flex justify-end">
      <?php _csrf(); ?>
      <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
    </div>
  </form>
</section>