<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.settings.index',
    'text' => t__('Settings')
  ],
  [
    'text' => t__('Vote')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('%module% Settings', ['%module%' => t__('Vote')]),
  'category' => 'settings.vote',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950"><?php e__('%module% Settings', ['%module%' => t__('Vote')]) ?></h1>
    <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <?php _message(); ?>

  <form action="<?php echo url('dashboard.settings.vote.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
    <?php _method('PATCH'); ?>
    <div class="mt-10 card p-6 grid gap-4">
	    <div x-data="textEditor()">
		    <label for="description" class="form-label"><?php e__('Description') ?>:</label>
		    <div class="mt-2">
	        <textarea x-ref="textEditor" class="form-control" name="description" id="description"><?php echo moduleSettings('vote', 'description') ?></textarea>
		    </div>
	    </div>
    </div>
    <div class="flex justify-end">
      <?php _csrf(); ?>
      <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
    </div>
  </form>
</section>