<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.sliders.index',
        'text' => t__('Slider')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Slider'),
    'category' => 'misc.slider',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Slider') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/slider" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.sliders.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.sliders.create') ?>" method="post" class="grid gap-4" enctype="multipart/form-data">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div>
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <input value="<?php _old('content') ?>" type="text" id="content" name="content" class="form-control">
            </div>
            <div>
                <label for="url" class="form-label">
                    <?php e__('Link') ?>
                </label>
                <input value="<?php _old('url') ?>" type="text" id="url" name="url" class="form-control">
            </div>
            <div>
                <label for="image" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div x-data="image">
                    <div class="mt-2 image-group" x-bind="imageContainer">
                        <img x-show="imagePreview !== null" :src="imagePreview" alt>
                        <span>
                          <?php e__('Select an image') ?>
                        </span>
                        <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>

