<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.sliders.index',
        'text' => t__('Slider')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $sliderItem['title']]),
    'category' => 'misc.slider',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $sliderItem['title']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/slider" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.sliders.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.sliders.update', ['id' => $sliderItem['id']]) ?>" enctype="multipart/form-data" method="post" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title', $sliderItem['title']) ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div>
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <input value="<?php _old('content', $sliderItem['content']) ?>" type="text" id="content" name="content" class="form-control">
            </div>
            <div>
                <label for="url" class="form-label">
                    <?php e__('Link') ?>
                </label>
                <input value="<?php _old('url', $sliderItem['url']) ?>" type="text" id="url" name="url" class="form-control">
            </div>
            <div>
                <label for="image" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div x-data="image">
                    <div class="mt-2 image-group" x-bind="imageContainer">
		                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                        <img x-show="imagePreview === null" src="<?php echo '/assets/core/images/slider/' . $sliderItem['imageID'] . '.' . $sliderItem['imageType'] ?>" alt="">
                        <span>
                          <?php e__('Select an image') ?>
                        </span>
                        <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" name="updateSlider" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

