<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.sliders.index',
        'text' => t__('Slider')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Slider'),
    'category' => 'misc.slider',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($sliderItems) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Slider') ?>
            </h1>
            <a href="<?php echo url('dashboard.sliders.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Slider')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="title">
								    <?php e__('Title') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="link">
								    <?php e__('Link') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="content">
								    <?php e__('Content') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($sliderItems as $sliderItem): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.sliders.edit', ['id' => $sliderItem['id']]) ?>" class="title"><?php echo $sliderItem['title'] ?></a>
								    <div>#<?php echo $sliderItem['id'] ?></div>
							    </td>
							    <td class="link">
								    <?php echo $sliderItem['url'] ?>
							    </td>
							    <td class="content">
								    <?php echo substr($sliderItem['content'], 0, 30) ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.sliders.edit', ['id' => $sliderItem['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.sliders.destroy', ['id' => $sliderItem['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No slider item found!'),
            'details' => t__('You can add new slider item by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.sliders.create',
                'text' => t__('Create Slider')
            ],
        ]);
    endif; ?>
</section>
