<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.stats.index',
        'text' => t__('Stats')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Stats'),
    'category' => 'misc.stats',
    'breadcrumbs' => $breadcrumbs
]) ?>


<div class="los-container py-9" x-cloak x-data="{
  types: [
    {
      id: 'overview',
      text: '<?php e__('Overview'); ?>'
    },
    {
      id: 'monthly_report',
      text: '<?php e__('Monthly Report'); ?>'
    },
    {
      id: 'payments',
      text: '<?php e__('Payments'); ?>'
    },
    {
      id: 'categories',
      text: '<?php e__('Categories'); ?>'
    },
    {
      id: 'donors',
      text: '<?php e__('Donors'); ?>'
    }
  ],
  selectedType: '<?php echo get("type") ?: 'overview' ?>',
  changeType: function(type) {
    this.selectedType = type;
    const searchParams = new URLSearchParams(window.location.search);
    searchParams.set('type', type);
    window.history.replaceState(null, null, '?' + searchParams.toString());
  },
  getSelectedType: function() {
    return this.types.find(type => type.id == this.selectedType);
  }
}">
    <div class="los-page-heading">
        <h1 class="header-title text-gray-950" x-text="getSelectedType().text"></h1>

        <div x-data="dropdown()" class="relative" style="min-width: 10rem">
            <div @click="toggle()" class="select-none btn !text-base bg-white !py-3 !px-5 flex items-center justify-between">
                <span class="mr-2.5" x-text="getSelectedType().text"></span>
                <i data-feather="arrow-down" class="w-5 h-5"></i>
            </div>

            <div x-bind="isDropdown" class="dropdown dark:bg-los-shiny w-44 mt-1">
                <template x-for="type in types">
                    <button
                      class="text-left !text-base dark:!bg-los-shiny dark:hover:!text-white"
                      :class="selectedType === type.id && '!bg-gray-100 dark:!bg-los-deep'"
                      x-text="type.text"
                      @click="toggle(); changeType(type.id);"
                    ></button>
                </template>
            </div>
        </div>
    </div>

    <div class="mt-10">
        <template x-if="getSelectedType().id === 'overview'">
            <div>
                <div class="mb-6">
                    <h4 class="text-gray-800"><?php e__('Sales') ?></h4>
                    <div class="mt-4 grid xl:grid-cols-4 gap-6">
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=all_time_sales').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("All Time") ?>
                            </h5>
                            <div>
                              <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                              <span class="h3 text-gray-950" x-text="data.sales" x-show="!isLoading"></span>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="card p-6"
                                 x-data="{data: [], isLoading: true}"
                                 x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=year_to_date_sales').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                            >
                                <h5 class="card-title">
                                    <?php e__("Year to Date") ?>
                                </h5>
                                <div>
                                    <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                    <span class="h3 text-gray-950" x-text="data.sales" x-show="!isLoading"></span>
                                </div>
                            </div>
                        </div>

                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=month_to_date_sales').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Month to Date") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.sales" x-show="!isLoading"></span>
                            </div>
                        </div>

                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=today_sales').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Today") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.sales" x-show="!isLoading"></span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-6">
                    <h4 class="text-gray-800"><?php e__('Support') ?></h4>
                    <div class="mt-4 grid xl:grid-cols-4 gap-6">
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=all_time_tickets').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("All Time") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.tickets" x-show="!isLoading"></span>
                            </div>
                        </div>

                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=month_to_date_tickets').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Month to Date") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.tickets" x-show="!isLoading"></span>
                            </div>
                        </div>

                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=closed_tickets').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Closed") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.tickets" x-show="!isLoading"></span>
                            </div>
                        </div>

                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=waiting_reply_tickets').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Waiting Reply") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.tickets" x-show="!isLoading"></span>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="mb-10">
                    <h4 class="text-gray-800"><?php e__('Registrations') ?></h4>
                    <div class="mt-4 grid xl:grid-cols-4 gap-6">
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=all_time_registrations').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("All Time") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.registrations" x-show="!isLoading"></span>
                            </div>
                        </div>

                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=year_to_date_registrations').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Year to Date") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.registrations" x-show="!isLoading"></span>
                            </div>
                        </div>
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=month_to_date_registrations').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Month to Date") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.registrations" x-show="!isLoading"></span>
                            </div>
                        </div>

                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=overview&get=today_registrations').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Today") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="data.registrations" x-show="!isLoading"></span>
                            </div>
                        </div>
                    </div>
                </div>
	            
	              <div>
		              <?php
			              $from = date('Y-m-d', strtotime("-1 month"));
			              $to = date('Y-m-d');
		              ?>
		              <div
			              x-data="{
		                  from: '<?php echo $from ?>',
		                  to: '<?php echo $to ?>',
		                  popularCategories: [],
		                  popularProducts: [],
		                  isGenerating: false,
		                  isLoading__popularCategories: true,
		                  isLoading__popularProducts: true,
		                  fetchPopularCategories: function() {
		                    this.isGenerating = true;
		                    fetch('/dashboard/ajax/stats?target=stats&type=overview&get=popular_categories&from=' + this.from + '&to=' + this.to).then(response => response.json())
		                   .then(response => { this.popularCategories = response; this.isLoading__popularCategories = false; this.isGenerating = false; })
		                  },
		                  fetchPopularProducts: function() {
		                    this.isGenerating = true;
		                    fetch('/dashboard/ajax/stats?target=stats&type=overview&get=popular_products&from=' + this.from + '&to=' + this.to).then(response => response.json())
		                   .then(response => { this.popularProducts = response; this.isLoading__popularProducts = false; this.isGenerating = false; })
		                  },
		                  fetchData: function() {
		                    this.isLoading__popularCategories = true;
		                    this.isLoading__popularProducts = true;
		                    this.isLoading__topDonors = true;
		                    this.fetchPopularCategories();
		                    this.fetchPopularProducts();
		                  }
		                }"
			              x-init="fetchData(); feather.replace();"
		              >
			              <div class="card p-6 grid grid-cols-1 xl:grid-cols-11 gap-y-4 lg:gap-x-3">
				              <div class="col-span-5">
					              <label for="datePickerFrom" class="form-label"><?php e__('From') ?>:</label>
					              <div class="input-absolute-group">
						              <i data-feather="calendar-2"></i>
						              <input x-data="statsDatePicker()" x-on:change="from = $event.target.value" type="text" id="datePickerFrom" class="form-control form-control-prepended" value="<?php echo $from; ?>">
					              </div>
				              </div>
				              <div class="col-span-5">
					              <label for="datePickerTo" class="form-label"><?php e__('To') ?>:</label>
					              <div class="input-absolute-group">
						              <i data-feather="calendar-2"></i>
						              <input x-data="statsDatePicker()" x-on:change="to = $event.target.value" type="text" id="datePickerTo" class="form-control form-control-prepended" value="<?php echo $to ?>">
					              </div>
				              </div>
				              <div class="lg:relative">
					              <div class="lg:absolute lg:bottom-0">
						              <button x-on:click="fetchData()" class="btn btn-success !py-2.5 !text-base w-full lg:w-auto" :class="isGenerating ? 'opacity-50 pointer-events-none' : ''"><?php e__('Generate') ?></button>
					              </div>
				              </div>
			              </div>
			              
			              <div class="grid grid-cols-1 lg:grid-cols-2 my-4 gap-4">
				              <div class="card p-6">
					              <h2 class="card-title mb-4"><?php e__('Popular Categories'); ?></h2>
					              <div x-show="isLoading__popularCategories">
						              <div class="sl-card sl-rounded-md mt-5">
							              <table class="sl-table">
								              <tbody>
								              <?php for($i = 0; $i < 5; $i++): ?>
									              <tr>
										              <td>
											              <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										              </td>
										              <td>
											              <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										              </td>
										              <td>
											              <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										              </td>
									              </tr>
								              <?php endfor; ?>
								              </tbody>
							              </table>
						              </div>
					              </div>
					              <template x-if="popularCategories.length > 0">
						              <table x-show="!isLoading__popularCategories" class="table">
							              <thead class="">
							              <tr class="table-header">
								              <th scope="col" class="text-left">
									              <?php e__('Category') ?>
								              </th>
								              <th scope="col" class="text-left">
									              <?php e__('Quantity') ?>
								              </th>
								              <th scope="col" class="text-left">
									              <?php e__('Total') ?>
								              </th>
							              </tr>
							              </thead>
							              <tbody class="divide-y divide-gray-200/20 text-center">
							              <template x-for="popularCategory in popularCategories">
								              <tr>
									              <td class="text-left">
										              <a :href="'/dashboard/store/categories/' + popularCategory.id + '/edit'" class="text-sm text-gray-500" x-text="popularCategory.category"></a>
									              </td>
									              <td class="text-left">
										              <p class="text-sm text-gray-500" x-text="'x' + popularCategory.quantity"></p>
									              </td>
									              <td class="text-left">
										              <p class="text-sm text-gray-500" x-text="popularCategory.total"></p>
									              </td>
								              </tr>
							              </template>
							              </tbody>
						              </table>
					              </template>
					              <template x-if="popularCategories.length === 0 && !isLoading__popularCategories">
						              <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
							              <?php e__("No data found!") ?>
						              </div>
					              </template>
				              </div>
				              <div class="card p-6">
					              <h2 class="card-title mb-4"><?php e__('Popular Products'); ?></h2>
					              <div x-show="isLoading__popularProducts">
						              <div class="sl-card sl-rounded-md mt-5">
							              <table class="sl-table">
								              <tbody>
								              <?php for($i = 0; $i < 5; $i++): ?>
									              <tr>
										              <td>
											              <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										              </td>
										              <td>
											              <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										              </td>
										              <td>
											              <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										              </td>
									              </tr>
								              <?php endfor; ?>
								              </tbody>
							              </table>
						              </div>
					              </div>
					              <template x-if="popularProducts.length > 0">
						              <table x-show="!isLoading__popularProducts" class="table">
							              <thead class="">
							              <tr class="table-header">
								              <th scope="col" class="text-left">
									              <?php e__('Product') ?>
								              </th>
								              <th scope="col" class="text-left">
									              <?php e__('Quantity') ?>
								              </th>
								              <th scope="col" class="text-left">
									              <?php e__('Total') ?>
								              </th>
							              </tr>
							              </thead>
							              <tbody class="divide-y divide-gray-200/20 text-center">
							              <template x-for="popularProduct in popularProducts">
								              <tr>
									              <td class="text-left">
										              <a :href="'/dashboard/store/products/' + popularProduct.id + '/edit'" class="text-sm text-gray-500" x-text="popularProduct.product"></a>
									              </td>
									              <td class="text-left">
										              <p class="text-sm text-gray-500" x-text="'x' + popularProduct.quantity"></p>
									              </td>
									              <td class="text-left">
										              <p class="text-sm text-gray-500" x-text="popularProduct.total"></p>
									              </td>
								              </tr>
							              </template>
							              </tbody>
						              </table>
					              </template>
					              <template x-if="popularProducts.length === 0 && !isLoading__popularProducts">
						              <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
							              <?php e__("No data found!") ?>
						              </div>
					              </template>
				              </div>
			              </div>
		              </div>
	              </div>
            </div>
        </template>

        <template x-if="getSelectedType().id === 'monthly_report'">
            <div
                    x-data="{reports: [], isLoading: true}"
                    x-init="fetch('/dashboard/ajax/stats?target=stats&type=monthly_report').then(response => response.json()).then(response => { reports = response; isLoading = false; })"
            >
                <div class="card p-6" data-toggle="lists" data-lists-values='["reportDate", "reportSales", "reportRegistrations", "reportForumThreads", "reportForumReplies", "reportSupportTickets"]'>
                    <h2 class="card-title"><?php echo t__(date('F')) . " " . date('Y'); ?></h2>
                    <div x-show="isLoading">
                      <div class="sl-card sl-rounded-md mt-5">
                        <table class="sl-table">
                          <tbody>
                          <?php for($i = 0; $i < 10; $i++): ?>
                            <tr>
                              <td>
                                <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                              </td>
                              <td>
                                <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                              </td>
                              <td>
                                <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                              </td>
                              <td>
                                <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                              </td>
                              <td>
                                <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                              </td>
                              <td>
                                <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                              </td>
                            </tr>
                          <?php endfor; ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                    <table x-show="!isLoading" class="table">
                        <thead class="">
                        <tr class="table-header">
                            <th scope="col" class="text-left">
                                <a href="#" data-sort="reportDate"><?php e__('Date') ?></a>
                            </th>
                            <th scope="col">
                                <a href="#" data-sort="reportSales"><?php e__('Sales') ?></a>
                            </th>
                            <th scope="col">
                                <a href="#" data-sort="reportRegistrations"><?php e__('Registrations') ?></a>
                            </th>
                            <th scope="col">
                                <a href="#" data-sort="reportForumThreads"><?php e__('Forum Threads') ?></a>
                            </th>
                            <th scope="col">
                                <a href="#" data-sort="reportForumReplies"><?php e__('Forum Replies') ?></a>
                            </th>
                            <th scope="col">
                                <a href="#" data-sort="reportSupportTickets"><?php e__('Support Tickets') ?></a>
                            </th>
                        </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200/20 text-center">
                        <template x-for="report in reports">
                            <tr>
                                <td class="reportDate text-left">
                                    <p class="text-xs text-gray-500" x-text="moment(report.date).format('MMMM DD, YYYY')"></p>
                                </td>
                                <td class="reportSales">
                                    <p class="text-sm text-gray-500" x-text="report.earnings"></p>
                                </td>
                                <td class="reportRegistrations">
                                    <p class="text-sm text-gray-500" x-text="report.registrations"></p>
                                </td>
                                <td class="reportForumThreads">
                                    <p class="text-sm text-gray-500" x-text="report.forumThreads"></p>
                                </td>
                                <td class="reportForumReplies">
                                    <p class="text-sm text-gray-500" x-text="report.forumReplies"></p>
                                </td>
                                <td class="reportSupportTickets">
                                    <p class="text-sm text-gray-500" x-text="report.supportTickets"></p>
                                </td>
                            </tr>
                        </template>
                        </tbody>
                    </table>
                </div>
                <template x-if="!isLoading">
                    <script>//initList();</script>
                </template>
            </div>
        </template>

        <div
          x-show="getSelectedType().id === 'payments'"
          x-data="chart('payments_chart')"
        >
            <?php
            $from = date('Y-m-d', strtotime("-1 month"));
            $to = date('Y-m-d');
            ?>
            <div
                x-data="{
                  from: '<?php echo $from ?>',
                  to: '<?php echo $to ?>',
                  totalRevenue: 0,
                  avgDailyRevenue: 0,
                  popularPaymentGateway: '-',
                  isGenerating: false,
                  isFetched__chart: false,
                  isLoading__chart: true,
                  isLoading__totalRevenue: true,
                  isLoading__popularPaymentGateway: true,
                  isLoading__avgDailyRevenue: true,
                  chartInterval: 'daily',
                  chartIntervals: [
                    { id: 'daily', text: '<?php e__('Daily') ?>' },
                    { id: 'weekly', text: '<?php e__('Weekly') ?>' },
                  ],
                  changeChartInterval: function(interval) {
                    this.chartInterval = interval;
                    this.isLoading__chart = true;
                    this.fetchChartData();
                  },
                  getChartInterval: function() {
                    return this.chartIntervals.find(interval => interval.id == this.chartInterval);
                  },
                  fetchTotalRevenue: function() {
                    this.isGenerating = true;
                    fetch('/dashboard/ajax/stats?target=stats&type=payments&get=total_revenue&from=' + this.from + '&to=' + this.to).then(response => response.json())
                   .then(response => { this.totalRevenue = response.total; this.isLoading__totalRevenue = false; this.isGenerating = false; })
                  },
                  fetchAvgDailyRevenue: function() {
                    this.isGenerating = true;
                    fetch('/dashboard/ajax/stats?target=stats&type=payments&get=avg_daily_revenue&from=' + this.from + '&to=' + this.to).then(response => response.json()).then(response => { this.avgDailyRevenue = response.total; this.isLoading__avgDailyRevenue = false; this.isGenerating = false; })
                  },
                  fetchPopularPaymentGateway: function() {
                    this.isGenerating = true;
                    fetch('/dashboard/ajax/stats?target=stats&type=payments&get=popular_payment_gateway&from=' + this.from + '&to=' + this.to).then(response => response.json()).then(response => { this.popularPaymentGateway = response.paymentGateway; this.isLoading__popularPaymentGateway = false; this.isGenerating = false; })
                  },
                  fetchChartData: function() {
                    this.isGenerating = true;
                    fetch('/dashboard/ajax/stats?target=stats&type=payments&get=chart&interval=' + this.chartInterval + '&from=' + this.from + '&to=' + this.to).then(response => response.json()).then(response => {
                      let labels;
                      if (this.chartInterval === 'daily') {
                        labels = response.labels.map(label => moment(label).format('DD MMM YY'));
                      } else {
                        labels = response.labels.map(label => {
                          return '<?php escape_e__('Week from %date%') ?>'.replace('%date%', moment(label).format('DD MMM YY'));
                        });
                      }
                      if (this.isFetched__chart) {
                          updateChart(response.data, labels)
                      }
                      else {
                        updateChart(response.data, labels)
                        this.isFetched__chart = true;
                      }
                      console.log(response.data,response.labels)
                      this.isLoading__chart = false;
                      this.isGenerating = false;
                    })
                  },
                  fetchData: function() {
                    this.isLoading__chart = true;
                    this.isLoading__totalRevenue = true;
                    this.isLoading__popularPaymentGateway = true;
                    this.isLoading__avgDailyRevenue = true;
                    this.fetchTotalRevenue();
                    this.fetchAvgDailyRevenue();
                    this.fetchPopularPaymentGateway();
                    this.fetchChartData();
                  }
                }"
                x-init="fetchData()"
            >
                <div class="card p-6 grid grid-cols-1 xl:grid-cols-11 gap-y-4 lg:gap-x-3">
                    <div class="col-span-5">
                        <label for="datePickerFrom" class="form-label"><?php e__('From') ?>:</label>
                        <div class="input-absolute-group">
                          <i data-feather="calendar-2"></i>
                          <input x-data="statsDatePicker()" x-on:change="from = $event.target.value" type="text" id="datePickerFrom" class="form-control form-control-prepended" value="<?php echo $from; ?>">
                        </div>
                    </div>
                    <div class="col-span-5">
                        <label for="datePickerTo" class="form-label"><?php e__('To') ?>:</label>
                        <div class="input-absolute-group">
                          <i data-feather="calendar-2"></i>
                          <input x-data="statsDatePicker()" x-on:change="to = $event.target.value" type="text" id="datePickerTo" class="form-control form-control-prepended" value="<?php echo $to ?>">
                        </div>
                    </div>
                    <div class="lg:relative">
                        <div class="lg:absolute lg:bottom-0">
                            <button x-on:click="fetchData()" class="btn btn-success !py-2.5 !text-base w-full lg:w-auto" :class="isGenerating ? 'opacity-50 pointer-events-none' : ''"><?php e__('Generate') ?></button>
                        </div>
                    </div>
                </div>

                <div class="grid lg:grid-cols-3 gap-6 mt-8">
                    <div class="card p-6">
                        <div class="col">
                            <h4 class="card-title">
                                <?php e__("Total Revenue") ?>
                            </h4>
                            <div>
                                <div x-show="isLoading__totalRevenue" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                                <span class="h3 text-gray-950" x-text="totalRevenue" x-show="!isLoading__totalRevenue"></span>
                            </div>
                        </div>
                        <div class="col-auto">
                            <span class="h1 fe fe-dollar-sign text-muted mb-0"></span>
                        </div>
                    </div>

                    <div class="card p-6">
                        <div class="col">
                            <h4 class="card-title">
                                <?php e__("Popular Payment Method") ?>
                            </h4>
                            <div>
                              <div x-show="isLoading__popularPaymentGateway" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                              <span class="h3 text-gray-950" x-text="popularPaymentGateway" x-show="!isLoading__popularPaymentGateway"></span>
                            </div>
                        </div>
                        <div class="col-auto">
                            <span class="h1 fe fe-credit-card text-muted mb-0"></span>
                        </div>
                    </div>

                    <div class="card p-6">
                        <div class="col">
                            <h4 class="card-title">
                                <?php e__("AVG Daily Revenue") ?>
                            </h4>
                            <div>
                              <div x-show="isLoading__avgDailyRevenue" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
                              <span class="h3 text-gray-950" x-text="avgDailyRevenue" x-show="!isLoading__avgDailyRevenue"></span>
                            </div>
                        </div>
                        <div class="col-auto">
                            <span class="h1 fe fe-bar-chart text-muted mb-0"></span>
                        </div>
                    </div>
                </div>

                <div class="mt-8 card" x-data="tab('daily')">
                    <div class="flex justify-between items-center py-4 px-6">
                        <div class="card-title"><?php e__('Revenue') ?> (<?php echo settings('currency') ?>)</div>
                    </div>
                    <div class="pt-0">
                        <div class="flex flex-col md:flex-row justify-end px-6">
                            <div class="tab-container !flex-row gap-1 !pt-0 !pb-0">
                                <template x-for="interval in chartIntervals">
                                    <div @click="openTab(interval.id); interval.id !== getChartInterval().id && changeChartInterval(interval.id)"
                                         :class="{'active':activeTab === interval.id}" class="tab-item !px-6 active center flex-col">
                                        <span x-text="interval.text"></span>
                                    </div>
                                </template>
                            </div>
                        </div>

                        <div class="pt-4 pb-10 px-6">
                            <canvas id="payments_chart" x-ref="payments_chart" class="!w-full" height="100"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	    
		    <div
			    x-show="getSelectedType().id === 'categories'"
			    x-data="chart('categories_chart')"
		    >
			    <?php
				    $from = date('Y-m-d', strtotime("-1 month"));
				    $to = date('Y-m-d');
			    ?>
			    <div
				    x-data="{
	                  from: '<?php echo $from ?>',
	                  to: '<?php echo $to ?>',
	                  selectedCategory: null,
	                  totalRevenue: 0,
	                  totalPurchases: 0,
	                  popularProducts: [],
	                  isGenerating: false,
	                  isFetched__chart: false,
	                  isLoading__chart: true,
	                  isLoading__totalRevenue: true,
	                  isLoading__popularProducts: true,
	                  isLoading__totalPurchases: true,
	                  chartInterval: 'daily',
	                  chartIntervals: [
	                    { id: 'daily', text: '<?php e__('Daily') ?>' },
	                    { id: 'weekly', text: '<?php e__('Weekly') ?>' },
	                  ],
	                  changeChartInterval: function(interval) {
	                    this.chartInterval = interval;
	                    this.isLoading__chart = true;
	                    this.fetchChartData();
	                  },
	                  getChartInterval: function() {
	                    return this.chartIntervals.find(interval => interval.id == this.chartInterval);
	                  },
	                  fetchTotalRevenue: function() {
	                    this.isGenerating = true;
	                    fetch('/dashboard/ajax/stats?target=stats&type=categories&get=total_revenue&category=' + this.selectedCategory + '&from=' + this.from + '&to=' + this.to).then(response => response.json())
	                   .then(response => { this.totalRevenue = response.total; this.isLoading__totalRevenue = false; this.isGenerating = false; })
	                  },
	                  fetchTotalPurchases: function() {
	                    this.isGenerating = true;
	                    fetch('/dashboard/ajax/stats?target=stats&type=categories&get=total_purchases&category=' + this.selectedCategory + '&from=' + this.from + '&to=' + this.to).then(response => response.json()).then(response => { this.totalPurchases = response.total; this.isLoading__totalPurchases = false; this.isGenerating = false; })
	                  },
	                  fetchPopularProducts: function() {
	                    this.isGenerating = true;
	                    fetch('/dashboard/ajax/stats?target=stats&type=categories&get=popular_products&category=' + this.selectedCategory + '&from=' + this.from + '&to=' + this.to).then(response => response.json()).then(response => { this.popularProducts = response; this.isLoading__popularProducts = false; this.isGenerating = false; })
	                  },
	                  fetchChartData: function() {
	                    this.isGenerating = true;
	                    fetch('/dashboard/ajax/stats?target=stats&type=categories&get=chart&category=' + this.selectedCategory + '&interval=' + this.chartInterval + '&from=' + this.from + '&to=' + this.to).then(response => response.json()).then(response => {
	                      let labels;
	                      if (this.chartInterval === 'daily') {
	                        labels = response.labels.map(label => moment(label).format('DD MMM YY'));
	                      } else {
	                        labels = response.labels.map(label => {
	                          return '<?php escape_e__('Week from %date%') ?>'.replace('%date%', moment(label).format('DD MMM YY'));
	                        });
	                      }
	                      if (this.isFetched__chart) {
	                          updateChart(response.data, labels)
	                      }
	                      else {
	                        updateChart(response.data, labels)
	                        this.isFetched__chart = true;
	                      }
	                      console.log(response.data,response.labels)
	                      this.isLoading__chart = false;
	                      this.isGenerating = false;
	                    })
	                  },
	                  fetchData: function() {
	                    if (this.selectedCategory === null) {
	                      return;
	                    }
	                    this.isLoading__chart = true;
	                    this.isLoading__totalRevenue = true;
	                    this.isLoading__popularProducts = true;
	                    this.isLoading__totalPurchases = true;
	                    this.fetchTotalRevenue();
	                    this.fetchTotalPurchases();
	                    this.fetchPopularProducts();
	                    this.fetchChartData();
	                  }
	                }"
			    >
				    <div class="card p-6 grid grid-cols-1 xl:grid-cols-12 gap-y-4 lg:gap-x-3">
					    <div class="col-span-4">
						    <label for="datePickerFrom" class="form-label"><?php e__('From') ?>:</label>
						    <div class="input-absolute-group">
							    <i data-feather="calendar-2"></i>
							    <input x-data="statsDatePicker()" x-on:change="from = $event.target.value" type="text" id="datePickerFrom" class="form-control form-control-prepended" value="<?php echo $from; ?>">
						    </div>
					    </div>
					    <div class="col-span-4">
						    <label for="datePickerTo" class="form-label"><?php e__('To') ?>:</label>
						    <div class="input-absolute-group">
							    <i data-feather="calendar-2"></i>
							    <input x-data="statsDatePicker()" x-on:change="to = $event.target.value" type="text" id="datePickerTo" class="form-control form-control-prepended" value="<?php echo $to ?>">
						    </div>
					    </div>
					    <div class="col-span-3">
						    <label for="category" class="form-label"><?php e__('Category') ?>:</label>
						    <?php $this->insert('components/select-category', [
							    'name' => 'category',
							    'id' => 'category',
							    'placeholder' => t__('Select category'),
							    'selected' => null,
							    'onChange' => '(selected) => { selectedCategory = selected; }'
						    ]); ?>
					    </div>
					    <div class="lg:relative">
						    <div class="lg:absolute lg:bottom-0">
							    <button x-on:click="fetchData()" class="btn btn-success !py-2.5 !text-base w-full lg:w-auto" :class="isGenerating ? 'opacity-50 pointer-events-none' : ''"><?php e__('Generate') ?></button>
						    </div>
					    </div>
				    </div>
				    
				    <div x-show="selectedCategory != null && isFetched__chart" class="grid lg:grid-cols-2 gap-6 mt-8">
					    <div class="card p-6">
						    <div class="col">
							    <h4 class="card-title">
								    <?php e__("Total Sales") ?>
							    </h4>
							    <div>
								    <div x-show="isLoading__totalRevenue" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
								    <span class="h3 text-gray-950" x-text="totalRevenue" x-show="!isLoading__totalRevenue"></span>
							    </div>
						    </div>
						    <div class="col-auto">
							    <span class="h1 fe fe-dollar-sign text-muted mb-0"></span>
						    </div>
					    </div>
					    
					    <div class="card p-6">
						    <div class="col">
							    <h4 class="card-title">
								    <?php e__("Total Purchases") ?>
							    </h4>
							    <div>
								    <div x-show="isLoading__totalPurchases" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-32 !h-6 mt-2"></div>
								    <span class="h3 text-gray-950" x-text="totalPurchases" x-show="!isLoading__totalPurchases"></span>
							    </div>
						    </div>
						    <div class="col-auto">
							    <span class="h1 fe fe-bar-chart text-muted mb-0"></span>
						    </div>
					    </div>
				    </div>
				    
				    <div x-show="selectedCategory != null && isFetched__chart" class="card p-6 mt-8">
					    <h2 class="card-title mb-4"><?php e__('Popular Products'); ?></h2>
					    <div x-show="isLoading__popularProducts">
						    <div class="sl-card sl-rounded-md mt-5">
							    <table class="sl-table">
								    <tbody>
								    <?php for($i = 0; $i < 5; $i++): ?>
									    <tr>
										    <td>
											    <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										    </td>
										    <td>
											    <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										    </td>
										    <td>
											    <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										    </td>
										    <td>
											    <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										    </td>
										    <td>
											    <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										    </td>
										    <td>
											    <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
										    </td>
									    </tr>
								    <?php endfor; ?>
								    </tbody>
							    </table>
						    </div>
					    </div>
					    <template x-if="popularProducts.length > 0">
						    <table x-show="!isLoading__popularProducts" class="table">
							    <thead class="">
							    <tr class="table-header">
								    <th scope="col" class="text-left">
									    <?php e__('Product') ?>
								    </th>
								    <th scope="col" class="text-left">
									    <?php e__('Quantity') ?>
								    </th>
								    <th scope="col" class="text-left">
									    <?php e__('Total') ?>
								    </th>
							    </tr>
							    </thead>
							    <tbody class="divide-y divide-gray-200/20 text-center">
							    <template x-for="popularProduct in popularProducts">
								    <tr>
									    <td class="text-left">
										    <a :href="'/dashboard/store/products/' + popularProduct.id + '/edit'" class="text-sm text-gray-500" x-text="popularProduct.product"></a>
									    </td>
									    <td class="text-left">
										    <p class="text-sm text-gray-500" x-text="'x' + popularProduct.quantity"></p>
									    </td>
									    <td class="text-left">
										    <p class="text-sm text-gray-500" x-text="popularProduct.total"></p>
									    </td>
								    </tr>
							    </template>
							    </tbody>
						    </table>
					    </template>
					    <template x-if="popularProducts.length === 0 && !isLoading__popularProducts">
						    <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
							    <?php e__("No data found!") ?>
						    </div>
					    </template>
				    </div>
				    
				    <div x-show="selectedCategory != null && isFetched__chart" class="mt-8 card" x-data="tab('daily')">
					    <div class="flex justify-between items-center py-4 px-6">
						    <div class="card-title"><?php e__('Sales') ?></div>
					    </div>
					    <div class="pt-0">
						    <div class="flex flex-col md:flex-row justify-end px-6">
							    <div class="tab-container !flex-row gap-1 !pt-0 !pb-0">
								    <template x-for="interval in chartIntervals">
									    <div @click="openTab(interval.id); interval.id !== getChartInterval().id && changeChartInterval(interval.id)"
									         :class="{'active':activeTab === interval.id}" class="tab-item !px-6 active center flex-col">
										    <span x-text="interval.text"></span>
									    </div>
								    </template>
							    </div>
						    </div>
						    
						    <div class="pt-4 pb-10 px-6">
							    <canvas id="categories_chart" x-ref="categories_chart" class="!w-full" height="100"></canvas>
						    </div>
					    </div>
				    </div>
			    </div>
		    </div>

        <template x-if="getSelectedType().id === 'donors'">
            <div>
                <div class="mb-8">
                    <h3 class="text-gray-800"><?php e__('Top Donor') ?></h3>
                    <div class="grid xl:grid-cols-4 gap-6 mt-4">
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=donors&get=all_time').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("All Time") ?>
                            </h5>
                            <div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-20 mt-2"></div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
                                <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
		                            <a :href="data.userID !== '-' ? '/dashboard/accounts/' + data.userID : '#'" class="block text-xl font-medium text-gray-950 mt-1" x-text="data.displayName" x-show="!isLoading"></a>
		                            <span class="block text-sm font-medium text-gray-500" x-text="'@' + data.username" x-show="!isLoading && data.username !== '-'"></span>
                                <span class="block text-lg font-medium text-success mt-1" x-text="data.total" x-show="!isLoading"></span>
                            </div>
                        </div>
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=donors&get=annually').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Annually") ?>
                            </h5>
                            <div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-20 mt-2"></div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
	                            <a :href="data.userID !== '-' ? '/dashboard/accounts/' + data.userID : '#'" class="block text-xl font-medium text-gray-950 mt-1" x-text="data.displayName" x-show="!isLoading"></a>
	                            <span class="block text-sm font-medium text-gray-500" x-text="'@' + data.username" x-show="!isLoading && data.username !== '-'"></span>
	                            <span class="block text-lg font-medium text-success mt-1" x-text="data.total" x-show="!isLoading"></span>
                            </div>
                        </div>
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=donors&get=monthly').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Monthly") ?>
                            </h5>
                            <div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-20 mt-2"></div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
	                            <a :href="data.userID !== '-' ? '/dashboard/accounts/' + data.userID : '#'" class="block text-xl font-medium text-gray-950 mt-1" x-text="data.displayName" x-show="!isLoading"></a>
	                            <span class="block text-sm font-medium text-gray-500" x-text="'@' + data.username" x-show="!isLoading && data.username !== '-'"></span>
	                            <span class="block text-lg font-medium text-success mt-1" x-text="data.total" x-show="!isLoading"></span>
                            </div>
                        </div>
                        <div class="card p-6"
                             x-data="{data: [], isLoading: true}"
                             x-init="fetch('/dashboard/ajax/stats?target=stats&type=donors&get=today').then(response => response.json()).then(response => { data = response; isLoading = false; })"
                        >
                            <h5 class="card-title">
                                <?php e__("Today") ?>
                            </h5>
                            <div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-20 mt-2"></div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
	                            <div x-show="isLoading" class="sl sl-text sl-rounded-md sl-animation-shimmer !w-24 mt-1"></div>
	                            <a :href="data.userID !== '-' ? '/dashboard/accounts/' + data.userID : '#'" class="block text-xl font-medium text-gray-950 mt-1" x-text="data.displayName" x-show="!isLoading"></a>
	                            <span class="block text-sm font-medium text-gray-500" x-text="'@' + data.username" x-show="!isLoading && data.username !== '-'"></span>
	                            <span class="block text-lg font-medium text-success mt-1" x-text="data.total" x-show="!isLoading"></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <h3 class="text-gray-800"><?php e__('Top Donor List') ?></h3>
                    <div class="mt-4 grid lg:grid-cols-2 gap-6">
                        <div
                            x-data="{
                                data: [],
                                limit: 5,
                                isLoading: true,
                                fetch: function() {
                                    fetch('/dashboard/ajax/stats?target=stats&type=donors&get=all_time_list&limit=' + this.limit)
                                    .then(response => response.json())
                                    .then(response => {
                                        this.data = response;
                                        this.isLoading = false;
                                    })
                                },
                                setLimit: function(limit) {
                                    this.limit = limit;
                                    this.fetch();
                                }
                            }"
                            x-init="fetch()"
                            class="card p-3"
                        >
                            <div class="flex justify-between items-center pb-3">
                                <div class="card-title"><?php e__('All Time') ?></div>
                                <div>
                                    <select class="form-control !py-2 !px-4 !text-xs" x-on:change="(e) => setLimit(e.target.value)">
                                        <template x-for="item in [5, 10, 25, 50, 100]">
                                            <option x-text="'Top #' + item" :value="item"></option>
                                        </template>
                                    </select>
                                </div>
                            </div>

                            <div class="card-body p-0" :class="isLoading && 'is-loading'">
                                <div x-show="isLoading">
                                  <div class="sl-card sl-rounded-md">
                                    <table class="sl-table">
                                      <tbody>
                                      <tr>
                                        <td>
                                          <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                        </td>
                                        <td>
                                          <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                        </td>
                                      </tr>
                                      <tr>
                                        <td>
                                          <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                        </td>
                                        <td>
                                          <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                        </td>
                                      </tr>
                                      <tr>
                                        <td>
                                          <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                        </td>
                                        <td>
                                          <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                        </td>
                                      </tr>
                                      </tbody>
                                    </table>
                                  </div>
                                </div>
                                <template x-if="data.length > 0">
                                  <div class="table-responsive">
                                    <table class="table table-sm table-nowrap card-table">
                                      <thead>
                                      <tr class="table-header">
                                        <th class="text-center" style="width: 40px;">#</th>
                                        <th class="!text-left"><?php e__('User') ?></th>
                                        <th class="text-right"><?php e__('Amount') ?></th>
                                      </tr>
                                      </thead>
                                      <tbody>
                                      <template x-for="item in data">
                                        <tr>
                                          <td x-text="item.id" class="text-center" style="width: 40px;"></td>
	                                        <td class="!text-left">
		                                        <a :href="'/dashboard/accounts/' + item.userID" class="text-sm text-gray-700" x-text="item.displayName"></a>
		                                        <p class="text-xs text-gray-500" x-text="'@' + item.username"></p>
	                                        </td>
                                          <td x-text="item.total" class="text-right"></td>
                                        </tr>
                                      </template>
                                      </tbody>
                                    </table>
                                  </div>
                                </template>
                                <template x-if="data.length === 0 && !isLoading">
                                  <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
                                      <?php e__("No data found!") ?>
                                  </div>
                                </template>
                            </div>
                        </div>

                        <div x-data="{
                              data: [],
                              limit: 5,
                              isLoading: true,
                              fetch: function() {
                                fetch('/dashboard/ajax/stats?target=stats&type=donors&get=annually_list&limit=' + this.limit)
                                  .then(response => response.json())
                                  .then(response => {
                                    this.data = response;
                                    this.isLoading = false;
                                  })
                              },
                              setLimit: function(limit) {
                                this.limit = limit;
                                this.fetch();
                              }
                            }"
                             x-init="fetch()"
                             class="card p-3"
                          >
                            <div class="flex justify-between items-center pb-3">
                                <div class="card-title"><?php e__('Annually') ?></div>
                                <div>
                                    <select class="form-control !py-2 !px-4 !text-xs" x-on:change="(e) => setLimit(e.target.value)">
                                        <template x-for="item in [5, 10, 25, 50, 100]">
                                            <option x-text="'Top #' + item" :value="item"></option>
                                        </template>
                                    </select>
                                </div>
                            </div>

                            <div x-show="isLoading">
                              <div class="sl-card sl-rounded-md">
                                <table class="sl-table">
                                  <tbody>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                            <template x-if="data.length > 0">
                              <div class="table-responsive">
                                <table class="table table-sm table-nowrap card-table">
                                  <thead>
                                  <tr class="table-header">
                                    <th class="text-center" style="width: 40px;">#</th>
                                    <th class="!text-left"><?php e__('User') ?></th>
                                    <th class="text-right"><?php e__('Amount') ?></th>
                                  </tr>
                                  </thead>
                                  <tbody>
                                  <template x-for="item in data">
                                    <tr>
                                      <td x-text="item.id" class="text-center" style="width: 40px;"></td>
	                                    <td class="!text-left">
		                                    <a :href="'/dashboard/accounts/' + item.userID" class="text-sm text-gray-700" x-text="item.displayName"></a>
		                                    <p class="text-xs text-gray-500" x-text="'@' + item.username"></p>
	                                    </td>
                                      <td x-text="item.total" class="text-right"></td>
                                    </tr>
                                  </template>
                                  </tbody>
                                </table>
                              </div>
                            </template>
                            <template x-if="data.length === 0 && !isLoading">
                              <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
                                  <?php e__("No data found!") ?>
                              </div>
                            </template>
                        </div>

                        <div
                          x-data="{
                            data: [],
                            limit: 5,
                            isLoading: true,
                            fetch: function() {
                              fetch('/dashboard/ajax/stats?target=stats&type=donors&get=monthly_list&limit=' + this.limit)
                                .then(response => response.json())
                                .then(response => {
                                  this.data = response;
                                  this.isLoading = false;
                                })
                            },
                            setLimit: function(limit) {
                              this.limit = limit;
                              this.fetch();
                            }
                          }"
                          x-init="fetch()"
                          class="card p-3"
                        >
                            <div class="flex justify-between items-center">
                                <div class="card-title"><?php e__('Monthly') ?></div>
                                <div>
                                    <select class="form-control !py-2 !px-4 !text-xs" x-on:change="(e) => setLimit(e.target.value)">
                                        <template x-for="item in [5, 10, 25, 50, 100]">
                                            <option x-text="'Top #' + item" :value="item"></option>
                                        </template>
                                    </select>
                                </div>
                            </div>
                            <div x-show="isLoading">
                              <div class="sl-card sl-rounded-md">
                                <table class="sl-table">
                                  <tbody>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                            <template x-if="data.length > 0">
                              <div class="table-responsive">
                                <table class="table table-sm table-nowrap card-table">
                                  <thead>
                                  <tr class="table-header">
                                    <th class="text-center" style="width: 40px;">#</th>
                                    <th class="!text-left"><?php e__('User') ?></th>
                                    <th class="text-right"><?php e__('Amount') ?></th>
                                  </tr>
                                  </thead>
                                  <tbody>
                                  <template x-for="item in data">
                                    <tr>
                                      <td x-text="item.id" class="text-center" style="width: 40px;"></td>
	                                    <td class="!text-left">
		                                    <a :href="'/dashboard/accounts/' + item.userID" class="text-sm text-gray-700" x-text="item.displayName"></a>
		                                    <p class="text-xs text-gray-500" x-text="'@' + item.username"></p>
	                                    </td>
                                      <td x-text="item.total" class="text-right"></td>
                                    </tr>
                                  </template>
                                  </tbody>
                                </table>
                              </div>
                            </template>
                            <template x-if="data.length === 0 && !isLoading">
                              <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
                                  <?php e__("No data found!") ?>
                              </div>
                            </template>
                        </div>

                        <div
                          x-data="{
                            data: [],
                            limit: 5,
                            isLoading: true,
                            fetch: function() {
                              fetch('/dashboard/ajax/stats?target=stats&type=donors&get=today_list&limit=' + this.limit)
                                .then(response => response.json())
                                .then(response => {
                                  this.data = response;
                                  this.isLoading = false;
                                })
                            },
                            setLimit: function(limit) {
                              this.limit = limit;
                              this.fetch();
                            }
                          }"
                          x-init="fetch()"
                          class="card p-3"
                        >
                            <div class="flex justify-between items-center">
                                <div class="card-title"><?php e__('Today') ?></div>
                                <div>
                                    <select class="form-control !py-2 !px-4 !text-xs" x-on:change="(e) => setLimit(e.target.value)">
                                        <template x-for="item in [5, 10, 25, 50, 100]">
                                            <option x-text="'Top #' + item" :value="item"></option>
                                        </template>
                                    </select>
                                </div>
                            </div>
                            <div x-show="isLoading">
                              <div class="sl-card sl-rounded-md">
                                <table class="sl-table">
                                  <tbody>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                    <td>
                                      <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
                                    </td>
                                  </tr>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                            <template x-if="data.length > 0">
                              <div class="table-responsive">
                                <table class="table table-sm table-nowrap card-table">
                                  <thead>
                                  <tr class="table-header">
                                    <th class="text-center" style="width: 40px;">#</th>
                                    <th class="!text-left"><?php e__('User') ?></th>
                                    <th class="text-right"><?php e__('Amount') ?></th>
                                  </tr>
                                  </thead>
                                  <tbody>
                                  <template x-for="item in data">
                                    <tr>
                                      <td x-text="item.id" class="text-center" style="width: 40px;"></td>
	                                    <td class="!text-left">
		                                    <a :href="'/dashboard/accounts/' + item.userID" class="text-sm text-gray-700" x-text="item.displayName"></a>
		                                    <p class="text-xs text-gray-500" x-text="'@' + item.username"></p>
	                                    </td>
                                      <td x-text="item.total" class="text-right"></td>
                                    </tr>
                                  </template>
                                  </tbody>
                                </table>
                              </div>
                            </template>
                            <template x-if="data.length === 0 && !isLoading">
                                <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
                                  <?php e__("No data found!") ?>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>
		            <div>
			            <?php
				            $from = date('Y-m-d', strtotime("-1 month"));
				            $to = date('Y-m-d');
			            ?>
			            <div
				            x-data="{
			                  from: '<?php echo $from ?>',
			                  to: '<?php echo $to ?>',
			                  topDonors: [],
			                  isGenerating: false,
			                  isLoading__topDonors: true,
			                  fetchTopDonors: function() {
			                    this.isGenerating = true;
			                    fetch('/dashboard/ajax/stats?target=stats&type=donors&get=top_donors&from=' + this.from + '&to=' + this.to).then(response => response.json())
			                   .then(response => { this.topDonors = response; this.isLoading__topDonors = false; this.isGenerating = false; })
			                  },
			                  fetchData: function() {
			                    this.isLoading__topDonors = true;
			                    this.fetchTopDonors();
			                  }
			                }"
				            x-init="fetchData(); feather.replace();"
			            >
				            <div class="card p-6 mt-6">
					            <div class="grid grid-cols-1 xl:grid-cols-11 gap-y-4 lg:gap-x-3">
						            <div class="col-span-5">
							            <label for="datePickerFrom" class="form-label"><?php e__('From') ?>:</label>
							            <div class="input-absolute-group">
								            <i data-feather="calendar-2"></i>
								            <input x-data="statsDatePicker()" x-on:change="from = $event.target.value" type="text" id="datePickerFrom" class="form-control form-control-prepended" value="<?php echo $from; ?>">
							            </div>
						            </div>
						            <div class="col-span-5">
							            <label for="datePickerTo" class="form-label"><?php e__('To') ?>:</label>
							            <div class="input-absolute-group">
								            <i data-feather="calendar-2"></i>
								            <input x-data="statsDatePicker()" x-on:change="to = $event.target.value" type="text" id="datePickerTo" class="form-control form-control-prepended" value="<?php echo $to ?>">
							            </div>
						            </div>
						            <div class="lg:relative">
							            <div class="lg:absolute lg:bottom-0">
								            <button x-on:click="fetchData()" class="btn btn-success !py-2.5 !text-base w-full lg:w-auto" :class="isGenerating ? 'opacity-50 pointer-events-none' : ''"><?php e__('Generate') ?></button>
							            </div>
						            </div>
					            </div>
					            <div class="mt-4">
						            <div x-show="isLoading__topDonors">
							            <div class="sl-card sl-rounded-md mt-5">
								            <table class="sl-table">
									            <tbody>
									            <?php for($i = 0; $i < 5; $i++): ?>
										            <tr>
											            <td>
												            <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
											            </td>
											            <td>
												            <div class="sl sl-table-text sl-rounded-sm sl-animation-shimmer"></div>
											            </td>
										            </tr>
									            <?php endfor; ?>
									            </tbody>
								            </table>
							            </div>
						            </div>
						            <template x-if="topDonors.length > 0">
							            <table x-show="!isLoading__topDonors" class="table">
								            <thead class="">
								            <tr class="table-header">
									            <th scope="col" class="text-left">
										            <?php e__('User') ?>
									            </th>
									            <th scope="col" class="text-left">
										            <?php e__('Total') ?>
									            </th>
								            </tr>
								            </thead>
								            <tbody class="divide-y divide-gray-200/20 text-center">
								            <template x-for="donor in topDonors">
									            <tr>
										            <td class="text-left">
											            <a :href="'/dashboard/accounts/' + donor.userID" class="text-sm text-gray-700" x-text="donor.displayName"></a>
											            <p class="text-xs text-gray-500" x-text="'@' + donor.username"></p>
										            </td>
										            <td class="text-left">
											            <p class="text-sm text-gray-500" x-text="donor.total"></p>
										            </td>
									            </tr>
								            </template>
								            </tbody>
							            </table>
						            </template>
						            <template x-if="topDonors.length === 0 && !isLoading__topDonors">
							            <div class="bg-red-100 text-red-500 px-5 py-2.5 text-sm rounded-xl mt-2">
								            <?php e__("No data found!") ?>
							            </div>
						            </template>
					            </div>
				            </div>
			            </div>
		            </div>
            </div>
        </template>
    </div>
</div>