<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Bulk Discount')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Bulk Discount'),
    'category' => 'store.bulk-discount',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" type="text/css" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.7/themes/default/style.min.css">
<?php $this->end() ?>

<?php $this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.7/jstree.min.js"></script>
<script src="<?php echo $this->asset('/js/jstree.js') ?>"></script>
<?php $this->end() ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Bulk Discount') ?></h1>
		    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/bulk-discount" class="btn btn-dark" target="_blank">
			    <?php e__('Help') ?>
		    </a>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.store.bulk-discount.update') ?>" method="post" class="grid gap-4">
            <?php _method('PATCH'); ?>
            <div x-data="{discountDurationStatus: '<?php echo old('storeDiscountStatus', moduleSettings('store', 'discount')) == '0' ? 0 : 1; ?>'}">
                <div>
                  <?php $this->insert('components/toggle', [
                    'name' => 'storeDiscountStatus',
                    'default' => old('storeDiscountStatus', moduleSettings('store', 'discount')) == '0' ? '0' : '1',
                    'action' => 'discountDurationStatus = discountDurationStatus === \'1\' ? \'0\' : \'1\'',
                    'labelRight' => t__('Discount Status')
                  ]); ?>
                </div>
                <div x-show="discountDurationStatus === '1'" class="grid gap-4 mt-3">
                    <div>
                        <label for="storeDiscount" class="form-label"><?php e__('Discount') ?> <span class="text-gray-400/75">(%):</span></label>
                        <input value="<?php _old('storeDiscount', moduleSettings('store', 'discount') != 0 ? moduleSettings('store', 'discount') : null) ?>" type="text" id="storeDiscount" name="storeDiscount" class="form-control">
                    </div>
	                
		                <div>
			                <label for="expiryDate" class="form-label">
				                <?php e__('Expiry Date') ?>
			                </label>
			                <div class="input-group" x-data="datePickerWithCheckbox('<?php _old('expiryDate', moduleSettings('store', 'discountExpiryDate')) ?>')">
				                <div class="input-group-prepend">
					                <div class="input-group-text">
						                <i data-feather="calendar-2"></i>
					                </div>
				                </div>
				                <input
					                x-ref="datepicker"
					                type="text"
					                id="expiryDate"
					                name="expiryDate"
					                class="form-control !pl-0"
					                data-placeholder="<?php e__('Select date') ?>"
					                :disabled="isDisabled"
				                >
				                <div class="input-group-append">
					                <div class="input-group-text !bg-neutral-900">
						                <div class="flex gap-2 items-center">
							                <input
								                type="checkbox"
								                name="neverExpires"
								                class="form-checkbox"
								                id="neverExpires"
								                x-ref="neverCheckbox"
								                @click="toggleCheckbox"
							                >
							                <label class="form-label select-none !mb-0" for="neverExpires">
								                <?php e__('Never') ?>
							                </label>
						                </div>
					                </div>
				                </div>
			                </div>
		                </div>
	                
                    <div class="mt-3" x-data="{discountProductStatus: '<?php _old('storeDiscountProductStatus', (moduleSettings('store', 'discountProducts') == '0') ? 0 : 1) ?>'}">
                        <div>
                            <label for="storeDiscountProductStatus" class="form-label">
                                <?php echo t__('Products') ?>
                            </label>
                            <select x-data="select2Alpine()" x-init="changed('storeDiscountProductStatus',() => discountProductStatus=selected)" name="storeDiscountProductStatus" id="storeDiscountProductStatus">
                                <option value="0" <?php _selected(old('storeDiscountProductStatus', (moduleSettings('store', 'discountProducts') == '0') ? 0 : 1) == '0'); ?>>
                                    <?php echo t__('All products') ?>
                                </option>
                                <option value="1" <?php _selected(old('storeDiscountProductStatus', (moduleSettings('store', 'discountProducts') == '0') ? 0 : 1) == '1'); ?>>
                                    <?php echo t__('Selected products') ?>
                                </option>
                            </select>
                        </div>
                        <div x-show="discountProductStatus === '1'" class="mt-3">
                            <div class="col-sm-10 offset-sm-2">
                                <div class="form-group">
                                    <input type="text" class="form-control " data-toggle="jstree-search" placeholder="<?php e__('Search...') ?>">
                                    <input type="hidden" data-toggle="jstree-value" name="storeDiscountProducts" value="<?php _old('storeDiscountProducts', moduleSettings('store', 'discountProducts') != 0 ? moduleSettings('store', 'discountProducts') : null); ?>">
                                </div>
                                <div class="mt-4" style="width: 400px" data-toggle="jstree" json="<?php echo url('dashboard.ajax.store.products.jstree') ?>"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php echo t__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

