<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.categories.index',
        'text' => t__('Categories')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $category["name"]]),
    'category' => 'store.categories',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Editing %text%', ['%text%' => $category["name"]]) ?></h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/categories" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.store.categories.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.store.categories.update', ['id' => $category["id"]]) ?>" method="post" enctype="multipart/form-data" class="grid gap-4 mt-10">
        <?php _method('PATCH'); ?>
        <div class="card p-6 grid gap-4">
            <div class="card-title mb-4">
                <?php e__('Category Details') ?>
            </div>
            <div class="grid grid-cols-7 gap-6">
                <div class="col-span-5">
                    <div>
                        <label for="name" class="form-label">
                            <?php e__('Name') ?>
                        </label>
                        <input value="<?php _old('name', $category["name"]) ?>" type="text" id="name" name="name" class="form-control">
                    </div>
                    <div class="mt-3">
                        <div class="mt-3">
                            <label for="parentID" class="form-label">
                                <?php e__('Parent Category') ?>
                            </label>
                            <?php $this->insert('components/select-category', [
                              'name' => 'parentID',
                              'id' => 'parentID',
                              'placeholder' => t__('Select category'),
                              'selected' => old('parentID', $category["parentID"]),
                              'list' => $categoryList
                            ]); ?>
                        </div>
                    </div>
                </div>
                <div class="col-span-2">
                    <div class="col-span-2">
                        <div x-data="image">
                            <label for="picture" class="form-label">
                                <?php e__('Image') ?>
                            </label>
                            <div class="mt-2 image-group" x-bind="imageContainer">
                                <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                                <img x-show="imagePreview === null" src="/assets/core/images/store/categories/<?php echo $category["imageID"] . '.' . $category["imageType"]; ?>" alt="">
                                <span><?php e__('Select Image') ?></span>
                                <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card" x-data="tab('general')">
		        <div class="tab-container !flex-row !p-4 mb-2">
                <div @click="openTab('general')" :class="{'active':activeTab==='general'}" class="tab-item">
                    <?php e__('General') ?>
                </div>
			        <div @click="openTab('visibility')" :class="{'active':activeTab==='visibility'}" class="tab-item">
				        <?php e__('Visibility') ?>
			        </div>
                <div @click="openTab('gui')" :class="{'active':activeTab==='gui'}" class="tab-item">Minecraft GUI</div>
                <div @click="openTab('cumulative')" :class="{'active':activeTab==='cumulative'}" class="tab-item">
                    <?php e__('Cumulative') ?>
                </div>
            </div>
            <div class="p-6 pt-0">
                <div x-show="activeTab === 'general'" class="grid gap-4">
                    <div>
                        <label for="priority" class="form-label">
                            <?php e__('Priority') ?>
                        </label>
                        <input value="<?php _old('priority', $category["priority"]) ?>" name="priority" type="number" id="priority" class="form-control">
                    </div>
                </div>
		            <div x-show="activeTab === 'visibility'" class="grid gap-4">
			            <div>
				            <?php $this->insert('components/toggle', [
					            'name' => 'isActive',
					            'default' => old('isActive', $category["isActive"]),
					            'labelRight' => t__('Show in store'),
				            ]); ?>
			            </div>
			            <div>
				            <label for="requiredProducts" class="form-label">
					            <?php e__("Only Show If Customer Has Purchased Product") ?>
				            </label>
				            <?php $this->insert('components/select-product', [
					            'name' => 'requiredProducts[]',
					            'id' => 'requiredProducts',
					            'placeholder' => t__('Always show this category to customers'),
					            'selected' => old('requiredProducts', $category["requiredProducts"]),
					            'list' => $productList,
					            'multiple' => true,
				            ]); ?>
			            </div>
		            </div>
                <div x-show="activeTab === 'gui'">
                    <div x-data="{minecraftStatus: '<?php _old('minecraftStatus', $category["minecraftStatus"]) ?>'}">
                        <div>
                            <?php $this->insert('components/toggle', [
                                'name' => 'minecraftStatus',
                                'default' => old('minecraftStatus', $category["minecraftStatus"]),
                                'labelRight' => t__('Show in game'),
                                'action' => 'minecraftStatus = minecraftStatus == \'1\' ? \'0\' : \'1\''
                            ]); ?>
                        </div>
                        <div x-show="minecraftStatus === '1'">
                            <div class="mt-3">
                                <label for="minecraftTitle" class="form-label">
                                    <?php e__('Title') ?>
                                </label>
                                <input value="<?php _old('minecraftTitle', $category["minecraftTitle"]) ?>" name="minecraftTitle" type="text" id="minecraftTitle" class="form-control">
                            </div>
                            <div class="mt-3">
                                <label for="minecraftDescription" class="form-label">
                                    <?php e__('Description') ?>
                                </label>
                                <textarea name="minecraftDescription" type="text" id="minecraftDescription" class="form-control"><?php _old('minecraftDescription', $category["minecraftDescription"]) ?></textarea>
                            </div>
                            <div class="mt-3">
                                <label for="minecraftItem" class="form-label">
                                    <?php e__('Icon') ?>
                                </label>
                                <select x-data="minecraftIconPicker('<?php _old('minecraftItem', $category["minecraftItem"]) ?>')" name="minecraftItem" id="minecraftItem">
                                    <option></option>
                                </select>
                            </div>
		                        <div class="mt-3">
			                        <label for="minecraftItemModelID" class="form-label">
				                        <?php e__('Model ID') ?> (<?php e__('Optional') ?>)
			                        </label>
			                        <input value="<?php _old('minecraftItemModelID', $category["minecraftItemModelID"]) ?>" name="minecraftItemModelID" type="text" id="minecraftItemModelID" class="form-control">
		                        </div>
                        </div>
                    </div>
                </div>
                <div x-show="activeTab === 'cumulative'" class="grid gap-4">
                    <div>
                        <?php $this->insert('components/toggle', [
                            'name' => 'isCumulative',
                            'default' => old('isCumulative', $category["isCumulative"]),
                            'labelRight' => t__('Is Cumulative Category?'),
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success">
                <?php e__('Save Changes') ?>
            </button>
        </div>
    </form>
</section>

