<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Categories')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Store Categories'),
    'category' => 'store.categories',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($categories) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950"><?php e__('Store Categories') ?></h1>
            <a href="<?php echo url('dashboard.store.categories.create') ?>" class="btn btn-primary"><?php e__('Add New') ?></a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Store Categories')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="parent">
								    <?php e__('Parent Category') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="priority">
								    <?php e__('Priority') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($categories as $category): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $category['id']]) ?>" class="name"><?php echo $category['name'] ?></a>
								    <div>#<?php echo $category['id'] ?></div>
							    </td>
							    <td class="parent">
								    <?php echo(($category['parentID'] == 0) ? '-' : $category["parentCategoryName"]) ?>
							    </td>
							    <td class="priority">
								    <?php echo $category['priority'] ?>
							    </td>
							    
							    <td class="table-action-buttons">
								    <a href="/store/<?php echo $category["slug"]; ?>" x-bind="tooltip('<?php e__('View') ?>')" target="_blank" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $category['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    
								    </a>
								    <form action="<?php echo url('dashboard.store.categories.destroy', ['id' => $category['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No store categories found!'),
            'details' => t__('You can add new store categories by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.store.categories.create',
                'text' => t__('Create Store Category')
            ],
        ]);
    endif; ?>
</section>
