<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Chest Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Chest Logs'),
    'category' => 'logs.chest',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($chestLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Chest Logs') ?>
            </h1>
        </div>
		    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.store.chest-logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Chest Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px;">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Product') ?>
						    </th>
						    <th>
							    <?php e__('Category') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Action') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($chestLogs as $chestLog): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $chestLog['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $chestLog['accountID']]) ?>"><?php echo $chestLog['realname'] ?></a>
								    <div>@<?php echo $chestLog['username'] ?></div>
							    </td>
							    <td class="not">
								    <a href="<?php echo url('dashboard.store.products.edit', ['id' => $chestLog['productID']]) ?>">
									    <?php echo $chestLog['productName'] ?>
								    </a>
							    </td>
							    <td class="not">
								    <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $chestLog['categoryID']]) ?>">
									    <?php echo $chestLog['categoryName'] ?>
								    </a>
							    </td>
							    <td class="flex justify-center">
								    <?php if ($chestLog["type"] == 1): ?>
									    <i data-feather="tick-circle" class="text-success w-4 h-4" x-bind="tooltip('<?php e__("Delivery") ?>')"></i>
								    <?php elseif ($chestLog["type"] == 2): ?>
									    <i data-feather="gift" class="w-4 h-4" x-bind="tooltip('<?php escape_e__('Gift to %username%', ['%username%' => $chestLog["otherAccountUsername"]]) ?>')"></i>
								    <?php elseif ($chestLog["type"] == 3): ?>
									    <i data-feather="gift" class="w-4 h-4" x-bind="tooltip('<?php escape_e__('Gift from %username%', ['%username%' => $chestLog["otherAccountUsername"]]) ?>')"></i>
								    <?php else: ?>
									    <i data-feather="check" class="w-4 h-4"></i>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($chestLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($chestLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.store.chest-logs.show', ['id' => $chestLog['id']]) ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <form action="<?php echo url('dashboard.store.chest-logs.destroy', ['id' => $chestLog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No chest logs found!'),
            'details' => t__('There are no chest logs to show here.')
        ]);
    endif; ?>
</section>
