<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.chest-logs.index',
        'text' => t__('Chest Logs')
    ],
    [
        'text' => t__('View')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('View'),
    'category' => 'logs.chest',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Chest Logs') ?>
        </h1>
        <a href="<?php echo url('dashboard.store.chest-logs.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <div class="mt-10 grid grid-cols-1 lg:grid-cols-10 gap-6">
        <div class="col-span-7">
            <div class="card py-4 px-6">
                <table class="table">
                    <thead>
                    <tr class="table-header">
                        <th scope="col" class="text-left">
                            <?php e__('Product') ?>
                        </th>
                        <th>
                          <?php e__('Category') ?>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                      <td class="!text-left">
                        <span class="text-sm text-gray-500"><?php echo $chestLog['productName'] ?></span>
	                      <?php if (count($chestLog["variables"]) > 0): ?>
		                      <div class="mt-1">
			                      <?php foreach ($chestLog["variables"] as $variable): ?>
				                      <div class="text-xs opacity-50">
					                      <?php echo $variable["name"] . ": " . $variable["value"]; ?>
				                      </div>
			                      <?php endforeach; ?>
		                      </div>
	                      <?php endif; ?>
                      </td>
                      <td class="text-center">
                        <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $chestLog['categoryID']]) ?>" class="text-sm text-gray-500" x-bind="tooltip('<?php echo str_replace(["'", '"'], ["\'", '\"'], $chestLog['categoryList']); ?>', 'top')">
                          <?php echo $chestLog['categoryName'] ?>
                        </a>
                      </td>
                    </tr>
                    </tbody>
                </table>
            </div>

          <?php if ($commandLogs !== null && count($commandLogs) > 0): ?>
            <?php $this->insert('components/command-logs', [
              'dataType' => 'chest',
              'dataID' => $chestLog["chestID"],
              'commandLogs' => $commandLogs
            ]); ?>
          <?php endif; ?>
        </div>
        <div class="col-span-7 lg:col-span-3">
          <div class="card">
            <div class="card-title pt-4 px-6"><?php e__('Summary') ?></div>
            <div class="py-4 px-6">
              <div class="bg-gray-50 rounded-xl py-2 px-3 divide-y divide-gray-600/5">
                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('User') ?>:</span>
	                <div class="text-right">
		                <a href="<?php echo url('dashboard.accounts.show', ['id' => $chestLog['accountID']]) ?>" class="block text-sm font-normal text-gray-700">
			                <?php echo $chestLog["realname"]; ?>
		                </a>
		                <div class="text-xs font-normal text-gray-500">
			                @<?php echo $chestLog["username"]; ?>
		                </div>
	                </div>
                </div>
                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('Date') ?>:</span>
                  <span class="text-sm font-normal text-gray-500 text-right">
                      <?php echo convertTime($chestLog["creationDate"], 2, true); ?>
                  </span>
                </div>
                <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('Action') ?>:</span>
                  <span class="text-sm font-normal text-gray-500 text-right">
                    <?php if ($chestLog["type"] == 1): ?>
                      <?php e__("Delivery") ?>
                    <?php elseif ($chestLog["type"] == 2): ?>
                      <?php e__('Gift to %username%', ['%username%' => $chestLog["otherAccountUsername"]]); ?>
                    <?php elseif ($chestLog["type"] == 3): ?>
                      <?php e__('Gift from %username%', ['%username%' => $chestLog["otherAccountUsername"]]); ?>
                    <?php else: ?>
                      <?php e__("Delivery") ?>
                    <?php endif; ?>
                  </span>
                </div>
              </div>
            </div>
          </div>
        </div>
    </div>
</section>

