<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Send Chest Item')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Send Chest Item'),
    'category' => 'user-management.actions.send-chest-item',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php echo t__('Send Chest Item') ?>
        </h1>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.store.chest.send.send') ?>" method="post" class="grid gap-4">
            <div>
		            <label for="userID" class="form-label">
			            <?php echo t__('Search User') ?>
		            </label>
		            <?php $this->insert('components/search-user', [
									'userID' => $account !== null ? $account["id"] : null
		            ]); ?>
            </div>
            <div>
                <label for="productID" class="form-label">
                    <?php echo t__('Product') ?>
                </label>
                <?php $this->insert('components/select-product', [
                    'name' => 'productID',
                    'id' => 'productID',
                    'placeholder' => t__('Select product'),
                    'list' => $productList
                ]); ?>
            </div>
            <div>
                <label for="amount" class="form-label">
                    <?php echo t__('Amount') ?>
                </label>
                <input value="<?php _old('amount') ?>" type="text" id="amount" name="amount" class="form-control">
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php echo t__('Send') ?>
                </button>
            </div>
        </form>
    </div>
</section>

