<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Community Goals')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Community Goals'),
    'category' => 'store.community-goal',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" type="text/css" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.7/themes/default/style.min.css">
<style>
    .ck-editor__editable[role=textbox] {
        min-height: 100px;
    }
</style>
<?php $this->end() ?>

<?php $this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.7/jstree.min.js"></script>
<script src="<?php echo $this->asset('/js/jstree.js') ?>"></script>
<?php $this->end() ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Community Goals') ?></h1>
		    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/community-goals" class="btn btn-dark" target="_blank">
			    <?php e__('Help') ?>
		    </a>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.store.community-goals.update') ?>" method="post" class="grid gap-4">
            <?php _method('PATCH'); ?>
            <div x-data="{communityGoalStatus: '<?php echo old('communityGoalStatus', moduleSettings("store", "communityGoalStatus")) == '0' ? 0 : 1; ?>'}">
                <div>
                  <?php $this->insert('components/toggle', [
                    'name' => 'communityGoalStatus',
                    'default' => old('communityGoalStatus', moduleSettings("store", "communityGoalStatus")) == '0' ? '0' : '1',
                    'action' => 'communityGoalStatus = communityGoalStatus === \'1\' ? \'0\' : \'1\'',
                    'labelRight' => t__('Is active?')
                  ]); ?>
                </div>
                <div x-show="communityGoalStatus === '1'" class="grid gap-4 mt-3">
                    <div>
                        <label for="communityGoalTitle" class="form-label"><?php e__('Title') ?></label>
                        <input value="<?php _old('communityGoalTitle', moduleSettings('store', 'communityGoalTitle')) ?>" type="text" id="communityGoalTitle" name="communityGoalTitle" class="form-control">
                    </div>
                    <div class="grid grid-cols-1">
                      <label for="communityGoalDescription" class="form-label"><?php e__('Description') ?></label>
                      <div x-data="textEditor()">
                        <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="communityGoalDescription" id="communityGoalDescription"><?php _old('communityGoalDescription', moduleSettings('store', 'communityGoalDescription')) ?></textarea>
                      </div>
                    </div>
                    <div class="grid gap-4 grid-cols-1 lg:grid-cols-2">
                      <div>
                        <label for="communityGoalCurrent" class="form-label"><?php e__('Current') ?></label>
                        <div class="input-absolute-group-right">
                          <div class="text-gray-500 text-sm">
                            <?php echo settings('currency') ?>
                          </div>
                          <input value="<?php _old('communityGoalCurrent', moduleSettings('store', 'communityGoalCurrent')) ?>" type="text" id="communityGoalCurrent" name="communityGoalCurrent" class="form-control">
                        </div>
                      </div>
                      <div>
                        <label for="communityGoalTarget" class="form-label"><?php e__('Goal') ?></label>
                        <div class="input-absolute-group-right">
                          <div class="text-gray-500 text-sm">
                            <?php echo settings('currency') ?>
                          </div>
                          <input value="<?php _old('communityGoalTarget', moduleSettings('store', 'communityGoalTarget')) ?>" type="text" id="communityGoalTarget" name="communityGoalTarget" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div>
                      <?php $this->insert('components/toggle', [
                        'name' => 'communityGoalRepeat',
                        'default' => old('communityGoalRepeat', moduleSettings("store", "communityGoalRepeat")) == '0' ? '0' : '1',
                        'labelRight' => t__('Is repeatable?')
                      ]); ?>
                    </div>
                </div>
            </div>
            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php echo t__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

