<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Coupon Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Coupon Logs'),
    'category' => 'logs.coupon',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($couponLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Coupon Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.store.coupon-logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Coupon Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px;">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Coupon') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($couponLogs as $couponLog): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $couponLog['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $couponLog['accountID']]) ?>"><?php echo $couponLog['realname'] ?></a>
								    <div>@<?php echo $couponLog['username'] ?></div>
							    </td>
							    <td class="not">
								    <a href="<?php echo url('dashboard.store.coupons.edit', ['id' => $couponLog['couponID']]) ?>">
									    <?php echo $couponLog['couponName'] ?>
								    </a>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($couponLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($couponLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <form action="<?php echo url('dashboard.store.coupon-logs.destroy', ['id' => $couponLog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No coupon logs found!'),
            'details' => t__('There are no coupon logs to show here.')
        ]);
    endif; ?>
</section>
