<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.coupons.index',
        'text' => t__('Coupons')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $coupon['name']]),
    'category' => 'store.coupons',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" type="text/css" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.7/themes/default/style.min.css">
<?php $this->end() ?>

<?php $this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.7/jstree.min.js"></script>
<script src="<?php echo $this->asset('/js/jstree.js') ?>"></script>
<?php $this->end() ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $coupon['name']]) ?>
        </h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/coupons" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.store.coupons.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.store.coupons.update', ['id' => $coupon['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH'); ?>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Coupon Code') ?>
                </label>
                <input value="<?php _old('name', $coupon['name']) ?>" type="text" id="name" name="name" class="form-control">
            </div>
	        
		        <div>
			        <label for="expiryDate" class="form-label">
				        <?php e__('Expiry Date') ?>
			        </label>
			        <div class="input-group" x-data="datePickerWithCheckbox('<?php _old('expiryDate', $coupon['expiryDate']) ?>')">
				        <div class="input-group-prepend">
					        <div class="input-group-text">
						        <i data-feather="calendar-2"></i>
					        </div>
				        </div>
				        <input
					        x-ref="datepicker"
					        type="text"
					        id="expiryDate"
					        name="expiryDate"
					        class="form-control !pl-0"
					        data-placeholder="<?php e__('Select date') ?>"
					        :disabled="isDisabled"
				        >
				        <div class="input-group-append">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
								        type="checkbox"
								        name="neverExpires"
								        class="form-checkbox"
								        id="neverExpires"
								        x-ref="neverCheckbox"
								        @click="toggleCheckbox"
							        >
							        <label class="form-label select-none !mb-0" for="neverExpires">
								        <?php e__('Never') ?>
							        </label>
						        </div>
					        </div>
				        </div>
			        </div>
		        </div>
	        
		        <div>
			        <label for="redeemLimit" class="form-label">
				        <?php e__('Redeem Limit') ?>
			        </label>
			        <div class="input-group" data-toggle="unlimited-input" data-limit="<?php _old('redeemLimit', $coupon['redeemLimit']) ?>">
				        <input type="number" id="redeemLimit" name="redeemLimit" class="form-control">
				        <div class="input-group-append">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
								        type="checkbox"
								        name="unlimitedRedeemLimit"
								        class="form-checkbox"
								        id="unlimitedRedeemLimit"
							        >
							        <label class="form-label select-none !mb-0" for="unlimitedRedeemLimit">
								        <?php e__('Unlimited') ?>
							        </label>
						        </div>
					        </div>
				        </div>
			        </div>
		        </div>
	        
		        <div>
			        <label for="redeemLimitPerCustomer" class="form-label">
				        <?php e__('Redeem Limit Per Customer') ?>
			        </label>
			        <div class="input-group" data-toggle="unlimited-input" data-limit="<?php _old('redeemLimitPerCustomer', $coupon['redeemLimitPerCustomer']) ?>">
				        <input type="number" id="redeemLimitPerCustomer" name="redeemLimitPerCustomer" class="form-control">
				        <div class="input-group-append">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
								        type="checkbox"
								        name="unlimitedRedeemLimitPerCustomer"
								        class="form-checkbox"
								        id="unlimitedRedeemLimitPerCustomer"
							        >
							        <label class="form-label select-none !mb-0" for="unlimitedRedeemLimitPerCustomer">
								        <?php e__('Unlimited') ?>
							        </label>
						        </div>
					        </div>
				        </div>
			        </div>
		        </div>
	        
            <div>
                <label for="discount" class="form-label"><?php e__('Discount') ?> <span class="text-gray-400/75">(%)</span></label>
                <input value="<?php _old('discount', $coupon['discount']) ?>" type="text" id="discount" name="discount" class="form-control">
            </div>
            <div>
                <label for="minPayment" class="form-label">
                    <?php e__('Minimum Payment Amount') ?>
                </label>
                <input value="<?php _old('minPayment', $coupon['minPayment']) ?>" type="text" id="minPayment" name="minPayment" class="form-control">
            </div>

            <div x-data="{productsStatus: '<?php _old('productsStatus', $coupon["products"] == 0 ? '0' : '1') ?>'}">
                <div>
                    <label for="productsStatus" class="form-label">
                        <?php e__('Products') ?>
                    </label>
                    <select x-data="select2Alpine()" x-init="changed('productsStatus', () => {productsStatus = selected})" name="productsStatus" id="productsStatus">
                        <option value="0" <?php _selected(old('productsStatus', $coupon["products"] == 0 ? '0' : '1') == '0'); ?>>
                            <?php e__('All products') ?>
                        </option>
                        <option value="1" <?php _selected(old('productsStatus', $coupon["products"] == 0 ? '0' : '1') == '1'); ?>>
                            <?php e__('Selected products') ?>
                        </option>
                    </select>
                </div>
                <div x-show="productsStatus === '1'" class="mt-3">
                    <label for="" class="sr-only"></label>
                    <div class="col-sm-10 offset-sm-2">
                        <div class="form-group">
                            <input type="text" class="form-control " data-toggle="jstree-search" placeholder="<?php e__('Search...') ?>">
                            <input type="hidden" data-toggle="jstree-value" name="products" value="<?php echo $coupon["products"] != 0 ? $coupon["products"] : null; ?>">
                        </div>
                        <div class="mt-4" style="width: 400px" data-toggle="jstree" json="<?php echo url('dashboard.ajax.store.products.jstree') ?>"></div>
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

