<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Coupons')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Coupons'),
    'category' => 'store.coupons',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($coupons) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Coupons') ?>
            </h1>
            <a href="<?php echo url('dashboard.store.coupons.create') ?>" class="btn btn-primary">
                <?php echo t__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Coupons')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="expiryDate">
								    <?php e__('Expiry Date') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="redeemLimit">
								    <?php e__('Redeem Limit') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="couponLeft">
								    <?php e__('Left') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="date">
								    <?php e__('Date') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($coupons as $coupon): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.store.coupons.edit', ['id' => $coupon['id']]) ?>" class="name"><?php echo $coupon['name'] ?></a>
								    <div>#<?php echo $coupon['id'] ?></div>
							    </td>
							    <td class="expiryDate">
								    <?php echo(($coupon["expiryDate"] == '1000-01-01 00:00:00') ? t__('Lifetime') : getDuration($coupon["expiryDate"]) . ' ' . t__('day')); ?>
							    </td>
							    <td class="redeemLimit center">
								    <?php if ($coupon["redeemLimit"] == -1): ?>
									    <?php e__('Unlimited') ?>
								    <?php else: ?>
									    <?php echo $coupon['redeemLimit'] ?>
								    <?php endif; ?>
							    </td>
							    <td class="couponLeft center">
								    <?php if ($coupon["redeemLimit"] == -1): ?>
									    <?php e__('Unlimited') ?>
								    <?php else: ?>
									    <?php echo $coupon['left'] ?>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($coupon["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($coupon["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.store.coupons.edit', ['id' => $coupon['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.store.coupons.destroy', ['id' => $coupon['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No coupons found!'),
            'details' => t__('You can add new coupons by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.store.coupons.create',
                'text' => t__('Create Coupon')
            ],
        ]);
    endif; ?>
</section>
