<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.creator-codes.index',
        'text' => t__('Creator Codes')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Creator Code'),
    'category' => 'store.creator-codes',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Creator Code') ?></h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/creator-codes" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.store.creator-codes.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.store.creator-codes.create') ?>" method="post" class="grid gap-4">
	        <div>
		        <label for="creatorID" class="form-label">
			        <?php echo t__('Search Creator') ?>
		        </label>
		        <?php $this->insert('components/search-user', [
			        'id' => 'creatorID',
			        'name' => 'creatorID',
		        ]); ?>
	        </div>
	        
          <div>
            <label for="code" class="form-label">
              <?php e__('Creator Code') ?>
            </label>
	          <div class="input-absolute-group-right" x-data="generateRandomCode()">
		          <input x-ref="codeInput" value="<?php _old('code') ?>" type="text" id="code" name="code" class="form-control">
		          <div>
			          <button @click="generate" type="button" class="flex items-center justify-center gap-1 btn btn-dark !text-sm !px-2.5 !py-1 !rounded-md">
				          <i data-feather="refresh" class="w-4 h-4"></i>
				          <span><?php e__('Generate') ?></span>
			          </button>
		          </div>
	          </div>
          </div>
	        
          <div>
            <label for="discount" class="form-label"><?php e__('Discount') ?> <span class="text-gray-400/75">(%)</span></label>
            <input value="<?php _old('discount') ?>" type="text" id="discount" name="discount" class="form-control">
          </div>
	        
	        <div>
		        <label for="share" class="form-label"><?php e__('Revenue Share') ?> <span class="text-gray-400/75">(%)</span></label>
		        <input value="<?php _old('share') ?>" type="text" id="share" name="share" class="form-control">
	        </div>

          <div class="flex justify-end">
              <?php _csrf(); ?>
              <button type="submit" class="btn btn-success">
                  <?php e__('Create') ?>
              </button>
          </div>
        </form>
    </div>
</section>