<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Creator Codes')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Creator Codes'),
    'category' => 'store.creator-codes',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($creatorCodes) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Creator Codes') ?>
            </h1>
            <a href="<?php echo url('dashboard.store.creator-codes.create') ?>" class="btn btn-primary">
                <?php echo t__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Creator Codes')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="code">
								    <?php e__('Code') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="creator">
								    <?php e__('Creator') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="discount">
								    <?php e__('Discount') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="share">
								    <?php e__('Revenue Share') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="date">
								    <?php e__('Date') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($creatorCodes as $creatorCode): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.store.creator-codes.edit', ['id' => $creatorCode['id']]) ?>" class="code"><?php echo $creatorCode['code'] ?></a>
								    <div>#<?php echo $creatorCode['id'] ?></div>
							    </td>
							    <td class="creator">
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $creatorCode['creatorID']]) ?>" class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
									    <?php echo $creatorCode['realname'] ?>
								    </a>
								    <div>@<?php echo $creatorCode['username'] ?></div>
							    </td>
							    <td class="discount">
								    <?php e__('%value%%', ['%value%' => $creatorCode["discount"]]); ?>
							    </td>
							    <td class="share">
								    <?php e__('%value%%', ['%value%' => $creatorCode["share"]]); ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($creatorCode["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($creatorCode["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.store.creator-codes.edit', ['id' => $creatorCode['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.store.creator-codes.destroy', ['id' => $creatorCode['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No creator codes found!'),
            'details' => t__('You can add new creator codes by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.store.creator-codes.create',
                'text' => t__('Create Creator Code')
            ],
        ]);
    endif; ?>
</section>
