<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Creator Code Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Creator Code Logs'),
    'category' => 'logs.creator-code',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($creatorCodeLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Creator Code Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.store.creator-code-logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Creator Code Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px;">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Code') ?>
						    </th>
						    <th>
							    <?php e__('Discount') ?>
						    </th>
						    <th>
							    <?php e__('Revenue Share') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($creatorCodeLogs as $creatorCodeLog): ?>
						    <tr>
							    <td class="not">
								    <a href="<?php echo url('dashboard.store.orders.show', ['id' => $creatorCodeLog['orderID']]) ?>">
									    #<?php echo $creatorCodeLog['orderID'] ?>
								    </a>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $creatorCodeLog['accountID']]) ?>"><?php echo $creatorCodeLog['realname'] ?></a>
								    <div>@<?php echo $creatorCodeLog['username'] ?></div>
							    </td>
							    <td class="not">
								    <a href="<?php echo url('dashboard.store.creator-codes.edit', ['id' => $creatorCodeLog['codeID']]) ?>">
									    <?php echo $creatorCodeLog['code'] ?>
								    </a>
							    </td>
							    <td>
								    <?php echo money($creatorCodeLog["discount"]); ?>
							    </td>
							    <td>
								    <?php echo money($creatorCodeLog["revenueShare"]); ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($creatorCodeLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($creatorCodeLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <form action="<?php echo url('dashboard.store.creator-code-logs.destroy', ['id' => $creatorCodeLog['orderID']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No creator code logs found!'),
            'details' => t__('There are no creator code logs to show here.')
        ]);
    endif; ?>
</section>
