<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.credit-packages.index',
        'text' => t__('Credit Packages')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Credit Package'),
    'category' => 'store.credit-packages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Credit Package') ?></h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/credit-packages" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.store.credit-packages.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.store.credit-packages.create') ?>" method="post" enctype="multipart/form-data" class="mt-10 grid gap-6">
        <div class="card p-6 grid gap-4">
            <div class="card-title mb-4">
                <?php e__('Package Details') ?>
            </div>
            <div class="grid grid-cols-7 gap-6">
                <div class="col-span-5 flex flex-col gap-3">
                    <div>
                        <label for="name" class="form-label">
                            <?php e__('Name') ?>
                        </label>
                        <input value="<?php _old('name') ?>" type="text" id="name" name="name" class="form-control">
                    </div>
                    <div>
                        <label for="amount" class="form-label">
                            <?php e__('Credits') ?>
                        </label>
                        <input value="<?php _old('amount') ?>" type="text" id="amount" name="amount" class="form-control">
                    </div>
                    <div>
                        <label for="bonus" class="form-label">
                            <?php e__('Bonus') ?>
                        </label>
                        <input value="<?php _old('bonus') ?>" type="text" id="bonus" name="bonus" class="form-control">
                    </div>
                </div>
                <div class="col-span-2">
                    <div class="col-span-2">
                        <div x-data="image">
                            <label for="picture" class="form-label">
                                <?php e__('Image') ?>
                            </label>
                            <div class="mt-2 image-group" x-bind="imageContainer">
                                <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                                <span>
                                  <?php e__('Select an image') ?>
                                </span>
                                <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div x-data="textEditor()">
                <label for="details" class="form-label">
                    <?php e__('Details') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor"
                              name="details" id="details"><?php _old('details') ?></textarea>
                </div>
            </div>
        </div>


        <div class="card" x-data="tab('price')">
            <div class="tab-container !flex-row px-6">
                <div @click="openTab('price')" :class="{'active':activeTab==='price'}" class="tab-item">
                    <?php e__('Price') ?>
                </div>
                <div @click="openTab('stock')" :class="{'active':activeTab==='stock'}" class="tab-item">
                    <?php e__('Stock') ?>
                </div>
            </div>
            <div class="p-6 pt-0">
                <div x-show="activeTab === 'price'" class="grid gap-4">
                    <div>
                        <label for="price" class="form-label">
                            <?php e__('Price') ?>
                        </label>
                        <input value="<?php _old('price') ?>" type="number" step="any" id="price" name="price" class="form-control">
                    </div>
                    <div x-data="{discountStatus: '<?php _old('discountStatus') ?>'}">
                        <div>
                          <?php $this->insert('components/toggle', [
                            'name' => 'discountStatus',
                            'default' => old('discountStatus', '0'),
                            'action' => 'discountStatus = discountStatus === \'1\' ? \'0\' : \'1\'',
                            'labelRight' => t__('Discount')
                          ]); ?>
                        </div>
                        <div x-show="discountStatus === '1'" class="mt-3">
                            <div>
                                <label for="discountedPrice" class="form-label">
                                    <?php e__('Discounted Price') ?>
                                </label>
                                <input value="<?php _old('discountedPrice') ?>" name="discountedPrice" type="number" step="any" id="discountedPrice" class="form-control">
                            </div>
                            <div class="mt-3" x-data="{discountDurationStatus: '<?php _old('discountDurationStatus') ?>'}">
                                <div>
                                    <label for="discountDurationStatus" class="form-label">
                                        <?php e__('Discount Duration Status') ?>
                                    </label>
                                    <select x-data="select2Alpine()" x-init="changed('discountDurationStatus', () => discountDurationStatus = selected)" name="discountDurationStatus" id="discountDurationStatus">
                                        <option value="0" <?php _selected(old('discountDurationStatus') == '0'); ?>>
                                            <?php e__('Lifetime') ?>
                                        </option>
                                        <option value="1" <?php _selected(old('discountDurationStatus') == '1'); ?>>
                                            <?php e__('Temporary') ?>
                                        </option>
                                    </select>
                                </div>
                                <div x-show="discountDurationStatus === '1'" class="mt-3">
                                    <label for="discountDuration" class="form-label">
                                        <?php e__('Discount Duration') ?>
                                    </label>
                                    <div class="input-absolute-group">
                                      <i data-feather="calendar-2"></i>
                                      <input x-data="datePicker()" value="<?php _old('discountDuration') ?>" type="text" id="discountDuration" name="discountDuration" class="form-control" placeholder="<?php e__('Select date') ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div x-show="activeTab === 'stock'" class="grid gap-4">
                    <div x-data="{stockStatus: '<?php _old('stockStatus') ?>'}">
                        <div>
                          <?php $this->insert('components/toggle', [
                            'name' => 'stockStatus',
                            'default' => old('stockStatus', '0'),
                            'action' => 'stockStatus = stockStatus === \'1\' ? \'0\' : \'1\'',
                            'labelRight' => t__('Stock Status')
                          ]); ?>
                        </div>
                        <div class="mt-3" x-show="stockStatus === '1'">
                            <label for="stock" class="form-label">
                                <?php e__('Stock') ?>
                            </label>
                            <input value="<?php _old('stock') ?>" name="stock" type="number" id="stock" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success">
                <?php e__('Create') ?>
            </button>
        </div>
    </form>
</section>