<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Credit Packages')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Credit Packages'),
    'category' => 'store.credit-packages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($packages) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Credit Packages') ?>
            </h1>
            <a href="<?php echo url('dashboard.store.credit-packages.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Credit Packages')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="price">
								    <?php e__('Price') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="amount">
								    <?php e__('Credits') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="bonus">
								    <?php e__('Bonus') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="stock">
								    <?php e__('Stock') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($packages as $package): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.store.credit-packages.edit', ['id' => $package['id']]) ?>" class="name"><?php echo $package['name'] ?></a>
								    <div>#<?php echo $package['id'] ?></div>
							    </td>
							    <td class="price">
								    <?php echo money(($package["discountedPrice"] > 0) ? $package["discountedPrice"] : $package["price"]); ?>
							    </td>
							    <td class="amount">
								    <?php echo $package['amount'] ?>
							    </td>
							    <td class="bonus">
								    <?php echo $package["bonus"] == 0 ? "-" : $package["bonus"]; ?>
							    </td>
							    
							    <td class="center">
								    <div class="stock"><?php echo ($package["stock"] == -1) ? '-' : $package["stock"]; ?></div>
								    <div><?php echo ($package["stock"] == -1) ? t__('Unlimited') : t__('Piece') ?></div>
							    </td>
							    
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.store.credit-packages.edit', ['id' => $package['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.store.credit-packages.destroy', ['id' => $package['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No credit packages found!'),
            'details' => t__('You can add new credit package by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.store.credit-packages.create',
                'text' => t__('Create Credit Package')
            ],
        ]);
    endif; ?>
</section>
