<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Credit Purchase Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Credit Purchase Logs'),
    'category' => 'logs.credit-purchase',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($creditPurchaseLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Credit Purchase Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.store.credit-usage-logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Credit Purchase Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px;">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Amount') ?>
						    </th>
						    <th>
							    <?php e__('Type') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($creditPurchaseLogs as $creditPurchaseLog): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $creditPurchaseLog['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $creditPurchaseLog['accountID']]) ?>"><?php echo $creditPurchaseLog['realname'] ?></a>
								    <div>@<?php echo $creditPurchaseLog['username'] ?></div>
							    </td>
							    <td class="not">
								    <?php echo ($creditPurchaseLog["type"] == 1 || $creditPurchaseLog["type"] == 4 || $creditPurchaseLog["type"] == 6 || $creditPurchaseLog["type"] == 8) ? '<span class="text-success">+' . $creditPurchaseLog["price"] . '</span>' : '<span class="text-danger">-' . $creditPurchaseLog["price"] . '</span>'; ?>
							    </td>
							    <td class="not">
								    <?php if ($creditPurchaseLog["type"] == 1): ?>
									    <span class="text-success flex items-center">+<i class="w-4" data-feather="coin" x-bind="tooltip('<?php e__("Charge") ?>')"></i></span>
								    <?php else: ?>
									    <i class="w-4" data-feather="money-send"></i>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($creditPurchaseLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($creditPurchaseLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <form action="<?php echo url('dashboard.store.credit-usage-logs.destroy', ['id' => $creditPurchaseLog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No credit purchase logs found!'),
            'details' => t__('You can create a new credit purchase log by clicking the button below.'),
        ]);
    endif; ?>
</section>
