<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Credit Usage Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Credit Usage Logs'),
    'category' => 'logs.credit-usage',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($creditUsageLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Credit Usage Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.store.credit-usage-logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Credit Usage Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px;">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Amount') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Type') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($creditUsageLogs as $creditUsageLog): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $creditUsageLog['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $creditUsageLog['accountID']]) ?>"><?php echo $creditUsageLog['realname'] ?></a>
								    <div>@<?php echo $creditUsageLog['username'] ?></div>
							    </td>
							    <td class="not">
								    <?php echo ($creditUsageLog["type"] == 1 || $creditUsageLog["type"] == 4 || $creditUsageLog["type"] == 6 || $creditUsageLog["type"] == 8) ? '<span class="text-success">+' . $creditUsageLog["price"] . '</span>' : '<span class="text-danger">-' . $creditUsageLog["price"] . '</span>'; ?>
							    </td>
							    <td>
								    <div class="text-sm text-gray-500 flex justify-center">
									    <?php if ($creditUsageLog["type"] == 1): ?>
										    <span class="text-success flex items-center">+<i class="w-4" data-feather="coin" x-bind="tooltip('<?php e__("Charge") ?>')"></i></span>
									    <?php elseif ($creditUsageLog["type"] == 2): ?>
										    <span class="text-danger flex items-center">-<i class="w-4" data-feather="coin" x-bind="tooltip('<?php e__("Usage") ?>')"></i></span>
									    <?php elseif ($creditUsageLog["type"] == 3): ?>
										    <i class="w-4" data-feather="money-send" x-bind="tooltip('<?php escape_e__('Transfer to %username%', ['%username%' => $creditUsageLog["otherAccountUsername"]]) ?>')"></i>
									    <?php elseif ($creditUsageLog["type"] == 4): ?>
										    <i class="w-4" data-feather="money-send" x-bind="tooltip('<?php escape_e__('Transfer from %username%', ['%username%' => $creditUsageLog["otherAccountUsername"]]) ?>')"></i>
									    <?php elseif ($creditUsageLog["type"] == 5): ?>
										    <i class="w-4" data-feather="ticket" x-bind="tooltip('<?php e__("Wheel of Fortune (Ticket)") ?>')"></i>
									    <?php elseif ($creditUsageLog["type"] == 6): ?>
										    <i class="w-4" data-feather="ticket" x-bind="tooltip('<?php e__("Wheel of Fortune (Prize)") ?>')"></i>
									    <?php elseif ($creditUsageLog["type"] == 7): ?>
										    <i class="w-4" data-feather="shop" x-bind="tooltip('<?php e__("Bazaar (Purchase)") ?>')"></i>
									    <?php elseif ($creditUsageLog["type"] == 8): ?>
										    <i class="w-4" data-feather="shop" x-bind="tooltip('<?php e__("Bazaar (Sell)") ?>')"></i>
									    <?php else: ?>
										    <i class="w-4" data-feather="money-send"></i>
									    <?php endif; ?>
								    </div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($creditUsageLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($creditUsageLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <form action="<?php echo url('dashboard.store.credit-usage-logs.destroy', ['id' => $creditUsageLog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No credit usage logs found!'),
            'details' => t__('There is no credit usage logs found.')
        ]);
    endif; ?>
</section>
