<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Send Credits')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Send Credits'),
    'category' => 'user-management.actions.send-credits',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php echo t__('Send Credits') ?>
        </h1>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.store.credit.send.send') ?>" method="post" class="grid gap-4">
            <div>
	            <label for="userID" class="form-label">
		            <?php echo t__('Search User') ?>
	            </label>
	            <?php $this->insert('components/search-user', [
		            'userID' => $account !== null ? $account["id"] : null
	            ]); ?>
            </div>
            <div>
                <label for="price" class="form-label">
                    <?php echo t__('Amount') ?>
                </label>
                <input value="<?php _old('amount') ?>" type="number" step="any" id="amount" name="amount" class="form-control">
            </div>
            <div>
              <label for="" class="form-label">
                <?php e__('Is earnings?') ?>
              </label>
              <?php $this->insert('components/toggle', [
                'name' => 'isEarnings',
                'default' => old('isEarnings', '1'),
              ]); ?>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php echo t__('Send') ?>
                </button>
            </div>
        </form>
    </div>
</section>

