<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Orders')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Orders'),
    'category' => 'store.orders',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($orders) > 0): ?>
        <div class="los-page-heading">
	        <h1 class="text-gray-950">
		        <?php e__('Orders') ?>
	        </h1>
	        <div class="flex gap-2">
		        <a href="<?php echo url('dashboard.store.orders.create') ?>" class="btn btn-primary">
			        <?php e__('Add New') ?>
		        </a>
	        </div>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 !grid grid-cols-12">
				    <div class="col-span-9">
					    <form method="get" action="<?php echo url('dashboard.store.orders.index') ?>" class="w-full">
						    <label for="search" class="form-label">
							    <?php e__('Search for %text%', ['%text%' => t__('Orders')]) ?>
						    </label>
						    <div class="input-absolute-group">
							    <i data-feather="search-normal"></i>
							    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
						    </div>
					    </form>
				    </div>
				    <div class="col-span-3">
					    <div class="flex w-full h-full">
						    <div x-data="dropdown()" class="relative w-full">
							    <label class="form-label">
								    <?php e__('Status') ?>
							    </label>
							    <div @click="toggle()" class="btn btn-sm btn-input">
								    <span x-text="selected"></span>
								    <i data-feather="arrow-down" class="w-4 h-4"></i>
							    </div>
							    
							    <div x-bind="isDropdown" class="dropdown w-full max-h-72 !overflow-y-auto">
								    <a href="<?php echo url('dashboard.store.orders.index') ?>">
									    <?php e__('Show All') ?>
								    </a>
								    <?php
									    $statuses = [
												'success' => t__('Success'),
                        'waiting' => t__('Waiting'),
                        'error' => t__('Error')
									    ];
								    ?>
								    <?php foreach ($statuses as $statusID => $status): ?>
									    <a href="<?php echo url('dashboard.store.orders.index') ?>?status=<?php echo $statusID; ?>" class="<?php _active(get('status') == $statusID); ?>">
										    <?php echo $status ?>
									    </a>
								    <?php endforeach; ?>
							    </div>
						    </div>
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px;">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Total') ?>
						    </th>
						    <th>
							    <?php e__('Payment Method') ?>
						    </th>
						    <th>
							    <?php e__('Status') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($orders as $order): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $order['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $order["accountID"]]) ?>">
									    <?php echo $order['realname'] ?>
								    </a>
								    <div>@<?php echo $order['username'] ?></div>
							    </td>
							    <td>
								    <?php
									    if ($order["type"] == 1) {
										    if (moduleSettings('store', 'isCreditRequiredOnPurchase') == 1) {
											    echo credits($order["total"]);
										    } else {
											    echo money($order["total"]);
										    }
									    } else {
										    echo money($order["earnings"]);
									    }
								    ?>
							    </td>
							    <td>
								    <?php
									    if ($order["paymentGateway"] == 'credit') {
										    e__('Credits');
									    } else {
										    echo $order["paymentGateway"];
									    }
								    ?>
							    </td>
							    <td class="not">
								    <?php if ($order["status"] == 1): ?>
									    <span class="badge badge-success"><?php e__('Success') ?></span>
								    <?php else: ?>
									    <?php if ($order["paymentAPI"] == "manual"): ?>
										    <span class="badge badge-warning"><?php e__('Waiting') ?></span>
									    <?php else: ?>
										    <span class="badge badge-danger"><?php e__('Error') ?></span>
									    <?php endif; ?>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($order["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($order["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.store.orders.show', ['id' => $order['id']]) ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <form action="<?php echo url('dashboard.store.orders.destroy', ['id' => $order['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No orders found!'),
            'details' => t__('There are no orders to show here.')
        ]);
    endif; ?>
</section>
