<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.orders.index',
        'text' => t__('Orders')
    ],
    [
        'text' => t__('View')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('View Order'),
    'category' => 'store.orders',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Order #%id%', ['%id%' => $order["id"]]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/orders" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.store.orders.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="mt-10 grid grid-cols-1 lg:grid-cols-10 gap-6">
        <div class="col-span-7">
            <div class="card py-4 px-6">
                <table class="table">
                    <colgroup>
                        <col style="width: 50%;">
                        <col style="width: 15%;">
                        <col style="width: 35%;">
                    </colgroup>
                    <thead>
                    <tr class="table-header">
                        <th scope="col" class="text-left">
                            <?php e__('Product') ?>
                        </th>
                        <?php if ($order["type"] == 1): ?>
                          <th scope="col">
                            <?php e__('Category') ?>
                          </th>
                        <?php endif; ?>
                        <th scope="col">
                            <?php e__('Quantity') ?>
                        </th>
                        <th scope="col" class="text-right">
                            <?php e__('Total') ?>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($orderProducts as $orderProduct): ?>
                        <tr>
                            <td class="!text-left">
                                <?php if ($order["type"] == 1): ?>
                                  <a href="<?php echo url('dashboard.store.products.edit', ['id' => $orderProduct['id']]) ?>" class="text-sm text-gray-500">
                                    <?php echo $orderProduct['name'] ?>
                                  </a>
	                                <?php if (count($orderProduct["variables"]) > 0): ?>
		                                <div class="mt-1">
			                                <?php foreach ($orderProduct["variables"] as $variable): ?>
				                                <div class="text-xs opacity-50">
					                                <?php echo $variable["name"] . ": " . $variable["value"]; ?>
				                                </div>
			                                <?php endforeach; ?>
		                                </div>
	                                <?php endif; ?>
                                <?php elseif ($order["type"] == 3): ?>
                                  <a href="<?php echo url('dashboard.store.credit-packages.edit', ['id' => $orderProduct['id']]) ?>" class="text-sm text-gray-500">
                                    <?php echo $orderProduct['name'] ?>
                                  </a>
                                <?php else: ?>
                                  <span class="text-sm text-gray-500">
                                    <?php echo $orderProduct['name'] ?>
                                  </span>
                                <?php endif; ?>
                            </td>
                            <?php if ($order["type"] == 1): ?>
                              <td>
                                <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $orderProduct['categoryID']]) ?>" x-bind="tooltip('<?php echo str_replace(["'", '"'], ["\'", '\"'], $orderProduct['categoryList']); ?>', 'top')" class="text-sm text-gray-500">
                                  <?php echo $orderProduct['categoryName'] ?>
                                </a>
                              </td>
                            <?php endif; ?>
                            <td>
                                <div class="text-sm text-gray-500">x<?php echo $orderProduct['quantity'] ?></div>
                            </td>
                            <td>
                                <div class="text-sm text-gray-500 block text-right">
                                  <?php
                                  if ($order["type"] == 1 && moduleSettings('store', 'isCreditRequiredOnPurchase') == 1) {
                                    echo credits($orderProduct["unitPrice"] * $orderProduct["quantity"]);
                                  } else {
                                    echo money($orderProduct["unitPrice"] * $orderProduct["quantity"]);
                                  }
                                  ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

          <?php if ($commandLogs !== null && count($commandLogs) > 0): ?>
            <?php $this->insert('components/command-logs', [
              'dataType' => 'order',
              'dataID' => $order["id"],
              'commandLogs' => $commandLogs
            ]); ?>
          <?php endif; ?>
        </div>
        <div class="col-span-7 lg:col-span-3">
          <div class="card">
            <div class="card-title pt-4 px-6"><?php e__('Summary') ?></div>
            <div class="py-4 px-6">
              <div class="bg-gray-50 rounded-xl py-2 px-3 divide-y divide-gray-600/5">
                <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('Status') ?>:</span>
                  <?php if ($order["status"] == 1): ?>
                    <span class="badge badge-success"><?php e__('Success') ?></span>
                  <?php else: ?>
                    <?php if ($order["paymentAPI"] == "manual"): ?>
                      <span class="badge badge-warning"><?php e__('Waiting') ?></span>
                    <?php else: ?>
                      <span class="badge badge-danger"><?php e__('Error') ?></span>
                    <?php endif; ?>
                  <?php endif; ?>
                </div>

                <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('User') ?>:</span>
                  <div class="text-right">
	                  <a href="<?php echo url('dashboard.accounts.show', ['id' => $order["accountID"]]) ?>" class="text-sm font-normal text-gray-700">
		                  <?php echo $order["realname"]; ?>
	                  </a>
	                  <div class="text-xs text-gray-500">
		                  @<?php echo $order["username"]; ?>
	                  </div>
                  </div>
                </div>

                <?php if ($order["coupon"] != null): ?>
                  <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                    <span class="text-sm"><?php e__('Coupon') ?>:</span>
                    <span class="text-sm font-normal text-gray-500 text-right">
                                <?php echo $order["coupon"]; ?>
                            </span>
                  </div>
                <?php endif; ?>
	              
	              <?php if ($order["creatorCode"] != null): ?>
		              <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
			              <span class="text-sm"><?php e__('Creator Code') ?>:</span>
			              <a class="text-sm font-normal text-gray-500 text-right" href="<?php echo url('dashboard.store.creator-codes.edit', ['id' => $order["creatorCode"]['codeID']]) ?>">
                      <?php echo $order["creatorCode"]["code"]; ?>
                    </a>
		              </div>
		              <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
			              <span class="text-sm"><?php e__('Revenue Share') ?>:</span>
			              <span class="text-sm font-normal text-gray-500 text-right">
                      <?php echo money($order["creatorCode"]["revenueShare"]); ?>
                    </span>
		              </div>
	              <?php endif; ?>

                <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('Payment Method') ?>:</span>
                  <span class="text-sm font-normal text-gray-500 text-right">
                    <?php if ($order["paymentGateway"] == 'credit'): ?>
                      <?php e__('Credits') ?>
                    <?php else: ?>
                    <?php echo $order["paymentGateway"] ?>
                    <?php endif; ?>
                  </span>
                </div>
                <?php if ($order["coupon"] != null || $order["credit"] > 0 || $order["tax"] > 0): ?>
                  <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                    <span class="text-sm"><?php e__('Subtotal') ?>:</span>
                    <span class="text-sm font-normal text-gray-500 text-right">
                      <?php echo money($order["subtotal"]); ?>
                    </span>
                  </div>
                <?php endif; ?>
	              <?php if ($order["tax"] > 0): ?>
		              <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
			              <span class="text-sm"><?php e__('Tax') ?>:</span>
			              <span class="text-sm font-normal text-gray-500 text-right">
				              <?php echo money($order["tax"]); ?>
			              </span>
		              </div>
	              <?php endif; ?>
	              <?php if ($order["gatewayFee"] > 0): ?>
		              <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
			              <span class="text-sm"><?php e__('Gateway Fee') ?>:</span>
			              <span class="text-sm font-normal text-gray-500 text-right">
				              <?php echo money($order["gatewayFee"]); ?>
			              </span>
		              </div>
	              <?php endif; ?>

                <?php if ($order["discount"] > 0): ?>
                  <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                    <span class="text-sm"><?php e__('Discount') ?>:</span>
                    <span class="text-sm font-normal text-gray-500 text-right">
                                -<?php echo money($order["discount"]); ?>
                            </span>
                  </div>
                <?php endif; ?>
                <?php if ($order["credit"] > 0): ?>
                  <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                    <span class="text-sm"><?php e__('Credit Usage') ?>:</span>
                    <span class="text-sm font-normal text-gray-500 text-right">
                                -<?php echo money($order["credit"]); ?>
                            </span>
                  </div>
                <?php endif; ?>
                <?php if ($order["cashback"] > 0): ?>
                  <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                    <span class="text-sm"><?php e__('Cashback') ?>:</span>
                    <span class="text-sm font-normal text-gray-500 text-right">
                                <?php echo money($order["cashback"]); ?>
                            </span>
                  </div>
                <?php endif; ?>
                <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('Total') ?>:</span>
                  <span class="text-sm font-normal text-gray-500 text-right">
                            <?php echo money($order["total"] - $order["credit"]); ?>
                        </span>
                </div>
                <div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
                  <span class="text-sm"><?php e__('Date') ?>:</span>
                  <span class="text-sm font-normal text-gray-500 text-right">
                            <?php echo convertTime($order["creationDate"], 2, true); ?>
                        </span>
                </div>

                <?php if ($order["paymentAPI"] == "manual" && $order["status"] != 1): ?>
                  <?php if ($order["credit"] > 0 && $order["credit"] > $order["userCredits"]): ?>
		                <button type="submit" class="btn btn-success w-full mt-2 flex items-center justify-center gap-1.5 opacity-50 pointer-events-none">
			                <i data-feather="tick-circle" class="w-4 h-4"></i>
			                <?php e__('Complete Order') ?>
		                </button>
		                <p class="block text-center text-xs text-red-400 mt-2">
			                <?php e__('The user does not have enough credits to complete this order.') ?>
		                </p>
	                <?php else: ?>
		                <form action="<?php echo url('dashboard.store.orders.complete', ['id' => $order["id"]]) ?>" method="post" data-submit-loading>
			                <?php _csrf(); ?>
			                <button type="submit" class="btn btn-success w-full mt-2 flex items-center justify-center gap-1.5">
				                <i data-feather="tick-circle" class="w-4 h-4"></i>
				                <?php e__('Complete Order') ?>
			                </button>
		                </form>
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
    </div>
</section>

