<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Products')
    ],
    [
        'text' => t__('Clone')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Cloning %text%', ['%text%' => $product['name']]),
    'category' => 'store.products',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section
	class="py-9 los-container tight-container"
	x-data="{
		showVariables: false,
		selectedProviders: [<?php echo implode(',', old('requiredLinkedAccounts', $product["requiredLinkedAccounts"])) ?>],
		selectedVariables: [<?php echo implode(',', old('variables', $product["variables"])) ?>],
		init() {
			document.querySelector('HTML').addEventListener('keydown', (event) => {
				const keyCode = event.keyCode || event.which
				
				if (keyCode === 27 && this.showVariables !== false) this.showVariables = false;
			})
		}
	}"
>
		<?php $this->insert('components/command-variables-modal', [
			'custom_variables' => $variables,
			'account_linking_providers' => $accountLinkingProviders
		]); ?>
	
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Cloning %text%', ['%text%' => $product['name']]) ?>
        </h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/products" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.store.products.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.store.products.store') ?>" method="post" enctype="multipart/form-data" class="mt-10 grid gap-6">
        <div class="card p-6 grid gap-4">
            <div class="card-title mb-4">
                <?php e__('Product Details') ?>
            </div>
            <div class="grid grid-cols-1 lg:grid-cols-7 gap-6">
                <div class="col-span-1 lg:col-span-5">
                    <div>
                        <label for="name" class="form-label">
                            <?php e__('Name') ?>
                        </label>
                        <input value="<?php _old('name', $product['name']) ?>" type="text" name="name" id="name" class="form-control">
                    </div>
                    <div class="mt-3">
                        <div class="mt-3">
                            <label for="categoryID" class="form-label">
                                <?php e__('Category') ?>
                            </label>
                            <?php $this->insert('components/select-category', [
                              'name' => 'categoryID',
                              'id' => 'categoryID',
                              'placeholder' => t__('Select category'),
                              'selected' => old('categoryID', $product["categoryID"])
                            ]); ?>
                        </div>
                    </div>
                </div>
                <div class="col-span-1 lg:col-span-2">
                    <div x-data="image">
                        <label for="picture" class="form-label">
                            <?php e__('Image') ?>
                        </label>
                        <div class="mt-2 image-group" x-bind="imageContainer">
                            <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                            <img x-show="imagePreview === null" src="/assets/core/images/store/products/<?php echo $product["imageID"] . '.' . $product["imageType"]; ?>" alt="">
                            <span>
                                  <?php e__('Select an image') ?>
                                </span>
                            <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                            <input type="hidden" name="imageID" value="<?php echo $product["imageID"]; ?>">
                            <input type="hidden" name="imageType" value="<?php echo $product["imageType"]; ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="grid grid-cols-1">
                <div>
                    <label for="details" class="form-label">
                        <?php e__('Details') ?>
                    </label>
                    <div x-data="textEditor()" class="mt-2 relative">
                      <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="details" id="details"><?php _old('details', $product['details']) ?></textarea>
	                    <?php $this->insert('components/ai/generate-button', [
		                    'target' => '#details',
		                    'type' => 'product_details',
	                    ]) ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="card" x-data="tab('general')">
		        <div class="tab-container !flex-row !p-4 mb-2">
                <div @click="openTab('general')" :class="{'active':activeTab==='general'}" class="tab-item">
                    <?php e__('General') ?>
                </div>
                <div @click="openTab('pricing')" :class="{'active':activeTab==='pricing'}" class="tab-item">
                    <?php e__('Pricing') ?>
                </div>
                <div @click="openTab('limits')" :class="{'active':activeTab==='limits'}" class="tab-item">
                    <?php e__('Limiting') ?>
                </div>
				        <div @click="openTab('restrictions')" :class="{'active':activeTab==='restrictions'}" class="tab-item">
					        <?php e__('Restrictions') ?>
				        </div>
				        <div @click="openTab('variables')" :class="{'active':activeTab==='variables'}" class="tab-item">
					        <?php e__('Variables') ?>
				        </div>
                <div @click="openTab('gui')" :class="{'active':activeTab==='gui'}" class="tab-item">Minecraft GUI</div>
            </div>
            <div class="p-6 pt-0">
                <div x-show="activeTab === 'general'" class="grid gap-4">
                    <div>
                      <?php $this->insert('components/toggle', [
                        'name' => 'isActive',
                        'default' => old('isActive', $product["isActive"]),
                        'labelRight' => t__('Show in store')
                      ]); ?>
                    </div>
		                <div>
			                <?php $this->insert('components/toggle', [
				                'name' => 'isFeaturedProduct',
				                'default' => old('isFeaturedProduct', $product["isFeaturedProduct"]),
				                'labelRight' => t__('Is featured product?')
			                ]); ?>
		                </div>
                    <div>
                        <label for="giveRoleID" class="form-label">
                            <?php e__('Give Role') ?>
                        </label>
                        <select x-data="select2Alpine()" name="giveRoleID" id="giveRoleID">
                            <option value="0"><?php e__('None') ?></option>
                            <?php foreach ($roles as $role): ?>
                                <option value="<?php echo $role["id"] ?>" <?php _selected(old('giveRoleID', $product["giveRoleID"]) == $role["id"]); ?>>
                                    <?php echo $role["name"] ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="priority" class="form-label">
                            <?php e__('Priority') ?>
                        </label>
                        <input value="<?php _old('priority', $product["priority"]) ?>" name="priority" type="number" id="priority" class="form-control">
                    </div>
                    <div x-data="{durationStatus: '<?php _old('durationStatus', $product["duration"] > 0 ? '1' : $product["duration"]); ?>'}">
                        <label for="durationStatus" class="form-label">
                            <?php e__('Duration Status') ?>
                        </label>
                        <select x-data="select2Alpine()" x-init="changed('durationStatus', () => durationStatus = selected)" name="durationStatus" id="durationStatus">
                            <option value="0" <?php _selected(old('durationStatus', $product["duration"] > 0 ? '1' : $product["duration"]) == '0'); ?>>
                                <?php e__('Lifetime') ?>
                            </option>
                            <option value="1" <?php _selected(old('durationStatus', $product["duration"] > 0 ? '1' : $product["duration"]) == '1'); ?>>
                                <?php e__('Temporary') ?>
                            </option>
                            <option value="-1" <?php _selected(old('durationStatus', $product["duration"] > 0 ? '1' : $product["duration"]) == '-1'); ?>>
                                <?php e__('One-Time') ?>
                            </option>
                        </select>
                        <div class="mt-3" x-show="durationStatus === '1'">
                          <div>
                            <label for="duration" class="form-label">
                              <?php e__('Duration') ?>
                            </label>
                            <input value="<?php _old('duration', $product["duration"] > 0 ? $product["duration"] : null) ?>" name="duration" type="number" id="duration" class="form-control">
                          </div>
                        </div>
                    </div>
                </div>
                <div x-show="activeTab === 'pricing'" class="grid gap-4">
                    <div>
                        <label for="price" class="form-label">
                            <?php e__('Price') ?>
                        </label>
                        <input value="<?php _old('price', $product["price"]) ?>" name="price" type="number" step="any" id="price" class="form-control">
                    </div>
                    <div x-data="{discountStatus: '<?php _old('discountStatus', $product["discountedPrice"] == 0 ? '0' : '1') ?>'}">
                        <div>
                          <?php $this->insert('components/toggle', [
                            'name' => 'discountStatus',
                            'default' => old('discountStatus', $product["discountedPrice"] == 0 ? '0' : '1'),
                            'action' => 'discountStatus = discountStatus === \'1\' ? \'0\' : \'1\'',
                            'labelRight' => t__('Discount')
                          ]); ?>
                        </div>
                        <div class="mt-3" x-show="discountStatus === '1'">
                            <div>
                                <label for="discountedPrice" class="form-label">
                                    <?php e__('Discounted Price') ?>
                                </label>
                                <input value="<?php _old('discountedPrice', $product['discountedPrice'] != 0 ? $product['discountedPrice'] : null) ?>" name="discountedPrice" type="number" step="any" id="discounted_price" class="form-control">
                            </div>
                            <div x-data="{discountDurationStatus: '<?php _old('discountDurationStatus', $product["discountExpiryDate"] == '1000-01-01 00:00:00' ? '0' : '1') ?>'}">
                                <div>
                                    <label for="discountDurationStatus" class="form-label">
                                        <?php e__('Discount Duration Status') ?>
                                    </label>
                                    <select x-data="select2Alpine()" x-init="changed('discountDurationStatus', () => discountDurationStatus = selected)" name="discountDurationStatus" id="discountDurationStatus">
                                        <option value="0" <?php _selected(old('discountDurationStatus', $product["discountExpiryDate"] == '1000-01-01 00:00:00' ? '0' : '1') == '0'); ?>>
                                            <?php e__('Lifetime') ?>
                                        </option>
                                        <option value="1" <?php _selected(old('discountDurationStatus', $product["discountExpiryDate"] == '1000-01-01 00:00:00' ? '0' : '1') == '1'); ?>>
                                            <?php e__('Temporary') ?>
                                        </option>
                                    </select>
                                </div>
                                <div class="mt-3" x-show="discountDurationStatus === '1'">
                                    <label for="discountDuration" class="form-label">
                                        <?php e__('Discount Duration') ?>
                                    </label>
                                    <div class="input-absolute-group">
                                        <i data-feather="calendar-2"></i>
                                        <input x-data="datePicker()" value="<?php _old('discountDuration', $product["discountExpiryDate"] != '1000-01-01 00:00:00' ? $product["discountExpiryDate"] : null) ?>" type="text" id="discountDuration" name="discountDuration" class="form-control" placeholder="<?php e__('Select date') ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div x-show="activeTab === 'limits'" class="grid gap-4">
                    <div x-data="{stockStatus: '<?php _old('stockStatus', $product["stock"] == -1 ? '0' : '1') ?>'}">
                        <div>
                          <?php $this->insert('components/toggle', [
                            'name' => 'stockStatus',
                            'default' => old('stockStatus', $product["stock"] == -1 ? '0' : '1'),
                            'action' => 'stockStatus = stockStatus === \'1\' ? \'0\' : \'1\'',
                            'labelRight' => t__('Stock Status')
                          ]); ?>
                        </div>
                        <div class="mt-3" x-show="stockStatus === '1'">
                            <label for="stock" class="form-label">
                                <?php e__('Stock') ?>
                            </label>
                            <input value="<?php _old('stock', $product["stock"] != -1 ? $product["stock"] : null) ?>" name="stock" type="number" id="stock" class="form-control">
                        </div>
                    </div>
                </div>
		            <div x-show="activeTab === 'restrictions'" class="grid gap-4">
			            <?php if (!moduleIsDisabled('account_linking')): ?>
				            <?php
				            $accountLinkingProvidersForSelect = array_map(function ($item) {
					            return [
						            'id' => $item['id'],
						            'text' => $item['name']
					            ];
				            }, $accountLinkingProviders);
				            ?>
				            <div>
					            <label for="requiredLinkedAccounts" class="form-label">
						            <?php e__("Required Linked Accounts") ?>
					            </label>
					            
					            <?php $this->insert('components/multi-select', [
						            'name' => 'requiredLinkedAccounts[]',
						            'id' => 'requiredLinkedAccounts',
						            'placeholder' => t__('None'),
						            'selected' => old('requiredLinkedAccounts', $product["requiredLinkedAccounts"]),
						            'list' => $accountLinkingProvidersForSelect,
						            'onChange' => '(selected) => {  selectedProviders = selected.map(num => parseInt(num)); }'
					            ]); ?>
				            </div>
			            <?php endif; ?>
			            <div>
				            <label for="requiredProducts" class="form-label">
					            <?php e__("Required Products") ?>
				            </label>
				            <?php $this->insert('components/select-product', [
					            'name' => 'requiredProducts[]',
					            'id' => 'requiredProducts',
					            'placeholder' => t__('None'),
					            'selected' => old('requiredProducts', $product["requiredProducts"]),
					            'list' => $productList,
					            'multiple' => true,
				            ]); ?>
			            </div>
			            <div>
				            <?php $this->insert('components/toggle', [
					            'name' => 'requireOnlyOneProduct',
					            'default' => old('requireOnlyOneProduct', $product["requireOnlyOneProduct"]),
					            'labelRight' => t__('Only require the customer to have purchased one product from the selected list.'),
				            ]); ?>
			            </div>
			            <div>
				            <?php $this->insert('components/toggle', [
					            'name' => 'disableGifting',
					            'default' => old('disableGifting', $product["disableGifting"]),
					            'labelRight' => t__('Do not allow this product to be gifted to another customer.'),
				            ]); ?>
			            </div>
			            <div>
				            <?php $this->insert('components/toggle', [
					            'name' => 'disableQuantity',
					            'default' => old('disableQuantity', $product["disableQuantity"]),
					            'labelRight' => t__('Do not allow the customer to increase the quantity of this product when purchasing.'),
				            ]); ?>
			            </div>
		            </div>
		            <div x-show="activeTab === 'variables'" class="grid gap-4">
			            <?php
				            $variablesForSelect = array_map(function ($item) {
					            return [
						            'id' => $item['id'],
						            'text' => '%' . $item['identifier'] . '%'
					            ];
				            }, $variables);
			            ?>
			            <div>
				            <label for="variables" class="form-label">
					            <?php e__("Variables") ?>
				            </label>
				            <?php $this->insert('components/multi-select', [
					            'name' => 'variables[]',
					            'id' => 'variables',
					            'placeholder' => t__('Select variables'),
					            'selected' => old('variables', $product["variables"]),
					            'list' => $variablesForSelect,
					            'onChange' => '(selected) => {  selectedVariables = selected.map(num => parseInt(num)); }'
				            ]); ?>
			            </div>
		            </div>
                <div x-show="activeTab === 'gui'" class="grid gap-4">
                    <div x-data="{minecraftStatus: '<?php _old('minecraftStatus', $product["minecraftStatus"]) ?>'}">
                        <div>
                          <?php $this->insert('components/toggle', [
                            'name' => 'minecraftStatus',
                            'default' => old('minecraftStatus', $product["minecraftStatus"]),
                            'labelRight' => t__('Show in game'),
                            'action' => 'minecraftStatus = minecraftStatus == \'1\' ? \'0\' : \'1\''
                          ]); ?>
                        </div>
                        <div x-show="minecraftStatus === '1'">
                            <div class="mt-3">
                                <label for="minecraftTitle" class="form-label">
                                    <?php e__('Title') ?>
                                </label>
                                <input value="<?php _old('minecraftTitle', $product["minecraftTitle"]) ?>" name="minecraftTitle" type="text" id="minecraftTitle" class="form-control">
                            </div>
                            <div class="mt-3">
                                <label for="minecraftDescription" class="form-label">
                                    <?php e__('Description') ?>
                                </label>
                                <textarea name="minecraftDescription" type="text" id="minecraftDescription" class="form-control"><?php _old('minecraftDescription', $product["minecraftDescription"]) ?></textarea>
                            </div>
                            <div class="mt-3">
                                <label for="minecraftItem" class="form-label">
                                    <?php e__('Icon') ?>
                                </label>
                                <select x-data="minecraftIconPicker('<?php _old('minecraftItem', $product["minecraftItem"]) ?>')" name="minecraftItem" id="minecraftItem">
                                    <option></option>
                                </select>
                            </div>
		                        <div class="mt-3">
			                        <label for="minecraftItemModelID" class="form-label">
				                        <?php e__('Model ID') ?> (<?php e__('Optional') ?>)
			                        </label>
			                        <input value="<?php _old('minecraftItemModelID', $product["minecraftItemModelID"]) ?>" name="minecraftItemModelID" type="text" id="minecraftItemModelID" class="form-control">
		                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card p-6">
          <?php
          $defaultInputs = array_map(function($commands, $commandIDs, $servers) {
            return [
              'commands' => $commands,
              'commandIDs' => $commandIDs,
              'servers' => $servers,
            ];
          }, old('commands', array_column($commands, 'command')), old('commandIDs', array_column($commands, 'id')), old('servers', array_column($commands, 'serverID')));
          ?>
          <div x-data="inputArray({
                        commands: '',
                        commandIDs: '',
                        servers: ''
                      }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
          >
            <div class="flex justify-between items-center">
              <div class="card-title">
                <?php e__('Commands') ?>
              </div>
	            <div class="flex gap-1">
		            <div @click="showVariables = true" class="btn btn-sm btn-default cursor-pointer flex items-center justify-center gap-1">
			            <?php e__('Variables') ?>
		            </div>
		            <div @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
			            <i data-feather="add" class="w-4 h-4 -ml-1"></i>
			            <?php e__('Add') ?>
		            </div>
	            </div>
            </div>
            <table class="mt-3 table">
              <colgroup>
                <col style="width: 80%;">
                <col style="width: 20%;">
              </colgroup>
              <thead class="">
              <tr class="table-header !text-xs !text-gray-500">
                <th scope="col" class="!text-left">
                  <?php e__('Command') ?>
                </th>
                <th scope="col" class="!text-left">
                  <?php e__('Server') ?>
                </th>
                <th scope="col" style="width: 40px">
                <span class="sr-only">
                  <?php e__('Actions') ?>
                </span>
                </th>
              </tr>
              </thead>
              <tbody class="divide-y divide-gray-200/20 text-center">
              <template x-for="(input, index) in inputs" :key="index">
                <tr>
                  <td class="!text-left !pl-0">
                    <input type="text" class="form-control" name="commands[]" x-bind:value="input.commands">
                    <input type="hidden" name="commandIDs[]" x-bind:value="input.commandIDs">
                  </td>
                  <td class="!text-left !pl-0">
                    <select name="servers[]" class="form-control" x-model="input.servers">
                      <?php foreach ($servers as $server): ?>
                        <option value="<?php echo $server["id"] ?>" :selected="input.servers === '<?php echo $server["id"] ?>'">
                          <?php echo $server["name"] ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                  </td>
                  <td class="justify-end flex items-center !px-0" style="width: 40px;">
                    <div @click="deleteInput(index)" class="btn btn-sheer btn-danger">
                      <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
                    </div>
                  </td>
                </tr>
              </template>
              </tbody>
            </table>
          </div>
        </div>

        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" name="insertProducts" class="btn btn-success">
                <?php e__('Create') ?>
            </button>
        </div>
    </form>
</section>