<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Products')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Products'),
    'category' => 'store.products',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
  <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.css">
<?php $this->end(); ?>

<?php $this->push('scripts') ?>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.js"></script>
<?php $this->end() ?>

<section class="los-container py-9">
    <?php if (count($tree) > 0): ?>
        <div class="los-page-heading">
          <div>
            <h1 class="text-gray-950">
              <?php e__('Products') ?>
            </h1>
            <div class="mt-3">
              <div class="flex gap-1 items-center border border-gray-300 dark:border-gray-600/40 py-1 px-1 rounded-2xl relative">
                <a href="<?php echo url('dashboard.store.products.index') ?>" class="btn btn-default !bg-gray-200 dark:!text-gray-700">
                  <?php e__('Default Listing') ?>
                </a>
                <a href="<?php echo url('dashboard.store.products.tableView') ?>" class="btn btn-default">
                  <?php e__('Table Listing') ?>
                </a>
              </div>
            </div>
          </div>
          <a href="<?php echo url('dashboard.store.products.create') ?>" class="btn btn-primary">
            <?php e__('Add New') ?>
          </a>
        </div>
        <div class="grid">
          <div
            x-data="advancedProductListing()"
            class="card p-6 mt-10"
          >
            <?php
              $this->insert('components/products-tree/wrapper', [
                'categories' => $tree,
              ]);
            ?>
          </div>
        </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No product found!'),
            'details' => t__('You can add new product by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.store.products.create',
                'text' => t__('Create Product')
            ],
        ]);
    endif; ?>
</section>
