<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Products')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Products'),
    'category' => 'store.products',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($products) > 0): ?>
        <div class="los-page-heading">
          <div>
            <h1 class="text-gray-950">
              <?php e__('Products') ?>
            </h1>
            <div class="mt-3">
              <div class="flex gap-1 items-center border border-gray-300 dark:border-gray-600/40 py-1 px-1 rounded-2xl relative">
                <a href="<?php echo url('dashboard.store.products.index') ?>" class="btn btn-default">
                  <?php e__('Default Listing') ?>
                </a>
                <a href="<?php echo url('dashboard.store.products.tableView') ?>" class="btn btn-default !bg-gray-200 dark:!text-gray-700">
                  <?php e__('Table Listing') ?>
                </a>
              </div>
            </div>
          </div>
          <a href="<?php echo url('dashboard.store.products.create') ?>" class="btn btn-primary">
            <?php e__('Add New') ?>
          </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Products')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="category">
								    <?php e__('Category') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="price">
								    <?php e__('Price') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="stock">
								    <?php e__('Stock') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="priority">
								    <?php e__('Priority') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($products as $product): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.store.products.edit', ['id' => $product['id']]) ?>" class="name"><?php echo $product['name'] ?></a>
								    <div>#<?php echo $product['id'] ?></div>
							    </td>
							    <td class="category not">
								    <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $product['categoryID']]) ?>">
								      <?php echo $product['categoryName'] ?>
								    </a>
							    </td>
							    <td class="center">
								    <div class="price">
									    <?php echo formatMoney(($product["discountedPrice"] > 0) ? $product["discountedPrice"] : $product["price"], (moduleSettings('store', 'isCreditRequiredOnPurchase') == 1 && moduleSettings('store', 'removeMoneyZeroDecimal') == 1)) ?>
								    </div>
								    <div>
									    <?php if (moduleSettings('store', 'isCreditRequiredOnPurchase') == 1): ?>
										    <?php echo (moduleSettings('credit', 'creditText') != "" && moduleSettings('credit', 'creditText') != null) ? moduleSettings('credit', 'creditText') : t__('Credits') ?>
									    <?php else: ?>
										    <?php echo settings('currency') ?>
									    <?php endif; ?>
								    </div>
							    </td>
							    <td class="center">
								    <div class="stock">
									    <?php echo ($product["stock"] == -1) ? t__('Unlimited') : $product["stock"]; ?>
								    </div>
								    <div><?php e__('in stock') ?></div>
							    </td>
							    <td class="priority">
								    <?php echo $product['priority'] ?>
							    </td>
							    
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.store.products.edit', ['id' => $product['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <a href="<?php echo url('dashboard.store.products.clone', ['id' => $product['id']]) ?>" x-bind="tooltip('<?php e__('Clone') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="copy"></i>
								    </a>
								    <form action="<?php echo url('dashboard.store.products.destroy', ['id' => $product['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No product found!'),
            'details' => t__('You can add new product by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.store.products.create',
                'text' => t__('Create Product')
            ],
        ]);
    endif; ?>
</section>
