<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'url' => 'dashboard.store.variables.index',
        'text' => t__('Variables')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $variable['name']]),
    'category' => 'store.variables',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $variable['name']]) ?>
        </h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/variables" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.store.variables.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>
	
		<form action="<?php echo url('dashboard.store.variables.update', ['id' => $variable['id']]) ?>" method="post" class="mt-10 grid gap-6" x-data="{type: '<?php _old('type', $variable['type']) ?>'}">
			<?php _method('PATCH'); ?>
			<div class="card p-6 grid gap-4">
				<div>
					<label for="identifier" class="form-label">
						<?php e__('Identifier') ?>
					</label>
					<input value="<?php _old('identifier', $variable['identifier']) ?>" type="text" id="identifier" name="identifier" class="form-control">
				</div>
				
				<div>
					<label for="name" class="form-label">
						<?php e__('Name') ?>
					</label>
					<input value="<?php _old('name', $variable['name']) ?>" type="text" id="name" name="name" class="form-control">
				</div>
				
				<div>
					<label for="description" class="form-label">
						<?php e__('Description') ?>
					</label>
					<input value="<?php _old('description', $variable['description']) ?>" type="text" id="description" name="description" class="form-control">
				</div>
				
				<div>
					<label for="type" class="form-label">
						<?php e__('Type') ?>
					</label>
					<select x-data="select2Alpine()" x-init="changed('type', () => type = selected)" name="type" id="type">
						<option value="text" <?php _selected(old('type', $variable['type']) == 'text'); ?>>
							<?php e__('Text') ?>
						</option>
						<option value="numeric" <?php _selected(old('type', $variable['type']) == 'numeric'); ?>>
							<?php e__('Numeric') ?>
						</option>
						<option value="dropdown" <?php _selected(old('type', $variable['type']) == 'dropdown'); ?>>
							<?php e__('Dropdown') ?>
						</option>
					</select>
				</div>
			</div>
			
			<div x-show="type === 'dropdown'">
				<div class="card p-6">
					<?php
						$defaultInputs = array_map(function($names, $values, $prices) {
							return [
								'names' => $names,
								'values' => $values,
								'prices' => $prices,
							];
						}, old('names', array_column($variable['dropdown'], 'name')), old('values', array_column($variable['dropdown'], 'value')), old('prices', array_column($variable['dropdown'], 'price')));
					?>
					<div
						x-data="inputArray({
            names: '',
            values: '',
            prices: '0.00'
          }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
					>
						<div class="flex justify-between items-center">
							<div class="card-title">
								<?php e__('Options') ?>
							</div>
							<span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
								<i data-feather="add" class="w-4 h-4 -ml-1"></i>
								<?php e__('Add') ?>
							</span>
						</div>
						<table class="mt-3 table">
							<thead class="">
							<tr class="table-header !text-xs !text-gray-500">
								<th scope="col" class="!text-left">
									<?php e__('Name') ?>
								</th>
								<th scope="col" class="!text-left">
									<?php e__('Value') ?>
								</th>
								<th scope="col" class="!text-left">
									<?php e__('Price') ?>
								</th>
								<th scope="col" style="width: 40px">
									<span class="sr-only">
										<?php e__('Actions') ?>
									</span>
								</th>
							</tr>
							</thead>
							<tbody x-data="sortable()" class="divide-y divide-gray-200/20 text-center">
							<template x-for="(input, index) in inputs" :key="index">
								<tr>
									<td class="!text-left !pl-0">
										<input type="text" class="form-control" name="names[]" x-bind:value="input.names">
									</td>
									<td class="!text-left !pl-0">
										<input type="text" class="form-control" name="values[]" x-bind:value="input.values">
									</td>
									<td class="!text-left !pl-0">
										<input type="text" class="form-control" name="prices[]" x-bind:value="input.prices">
									</td>
									<td class="justify-end flex items-center !px-0 gap-1" style="width: 80px;">
										<div class="btn btn-icon btn-secondary draggable-item">
											<i data-feather="move" class="h-4"></i>
										</div>
										<div @click="deleteInput(index)" class="btn btn-icon btn-sheer btn-danger">
											<i class="stroke-red-500 stroke-2 h-4" data-feather="trash"></i>
										</div>
									</td>
								</tr>
							</template>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			
			<div class="flex justify-end">
				<?php _csrf(); ?>
				<button type="submit" class="btn btn-success">
					<?php e__('Save Changes') ?>
				</button>
			</div>
		</form>
</section>

