<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.store.products.index',
        'text' => t__('Store')
    ],
    [
        'text' => t__('Variables')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Variables'),
    'category' => 'store.variables',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($variables) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Variables') ?>
            </h1>
            <a href="<?php echo url('dashboard.store.variables.create') ?>" class="btn btn-primary">
                <?php echo t__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Variables')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="identifier">
								    <?php e__('Identifier') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($variables as $variable): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.store.variables.edit', ['id' => $variable['id']]) ?>" class="name"><?php echo $variable['name'] ?></a>
								    <div>#<?php echo $variable['id'] ?></div>
							    </td>
							    <td class="identifier">
								    %<?php echo $variable["identifier"]; ?>%
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.store.variables.edit', ['id' => $variable['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.store.variables.destroy', ['id' => $variable['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No variables found!'),
            'details' => t__('You can add new variables by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.store.variables.create',
                'text' => t__('Create Variable')
            ],
        ]);
    endif; ?>
</section>
