<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.suggestions.index',
        'text' => t__('Suggestions')
    ],
    [
        'url' => 'dashboard.suggestions.categories.index',
        'text' => t__('Categories')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $category["name"]]),
    'category' => 'misc.suggestions.categories',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Editing %text%', ['%text%' => $category["name"]]) ?></h1>
        <a href="<?php echo url('dashboard.suggestions.categories.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.suggestions.categories.update', ['id' => $category['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div>
                <label for="name" class="form-label"><?php e__('Name') ?></label>
                <input value="<?php _old('name', $category['name']) ?>" type="text" id="name" name="name" class="form-control">
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

