<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.suggestions.index',
        'text' => t__('Suggestions')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Suggestion'),
    'category' => 'misc.suggestions.suggestions',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Suggestion') ?></h1>
        <a href="<?php echo url('dashboard.suggestions.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
        </a>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.suggestions.create') ?>" method="post" class="grid gap-5">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div>
                <label for="categoryID" class="form-label">
                    <?php e__('Category') ?>
                </label>
                <select x-data="select2Alpine()" name="categoryID" id="categoryID" required>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo $category["id"] ?>" <?php _selected(old('categoryID') == $category["id"]); ?>>
                            <?php echo $category["name"]; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content"><?php _old('content') ?></textarea>
                </div>
            </div>
            <div>
                <label for="views" class="form-label">
                    <?php e__('Views') ?>
                </label>
                <input value="<?php _old('views') ?>" type="number" id="views" name="views" class="form-control">
            </div>
            <div>
                <label for="likesCount" class="form-label">
                    <?php e__('Likes') ?>
                </label>
                <input value="<?php _old('likesCount') ?>" type="number" id="likesCount" name="likesCount" class="form-control">
            </div>
            <div>
                <label for="dislikesCount" class="form-label">
                    <?php e__('Dislikes') ?>
                </label>
                <input value="<?php _old('dislikesCount') ?>" type="number" id="dislikesCount" name="dislikesCount" class="form-control">
            </div>


            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>
