<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.suggestions.index',
        'text' => t__('Suggestions')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Suggestions'),
    'category' => 'misc.suggestions.suggestions',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($suggestions) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Suggestions') ?>
            </h1>
            <a href="<?php echo url('dashboard.suggestions.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.suggestions.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Suggestions')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Title') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('Author') ?>
						    </th>
						    <th>
							    <?php e__('Category') ?>
						    </th>
						    <th>
							    <?php e__('Likes/Dislikes') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($suggestions as $suggestion): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.suggestions.edit', ['id' => $suggestion['id']]) ?>"><?php echo $suggestion['title'] ?></a>
								    <div>#<?php echo $suggestion['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $suggestion['accountID']]) ?>"><?php echo $suggestion['realname'] ?></a>
							    </td>
							    <td>
								    <?php echo $suggestion['categoryName'] ?>
							    </td>
							    <td>
								    <?php echo $suggestion['likesCount'] ?>/<?php echo $suggestion['dislikesCount'] ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($suggestion["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($suggestion["creationDate"]) ?></div>
							    </td>
							    
							    <td class="table-action-buttons">
								    <a href="/suggestions/<?php echo $suggestion['id'] ?>/<?php echo $suggestion['slug'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.suggestions.edit', ['id' => $suggestion['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.suggestions.destroy', ['id' => $suggestion['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No suggestion found!'),
            'details' => t__('You can add new suggestion by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.suggestions.create',
                'text' => t__('Create Suggestion')
            ],
        ]);
    endif; ?>
</section>
