<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.support.tickets.index',
        'text' => t__('Support')
    ],
    [
        'url' => 'dashboard.support.categories.index',
        'text' => t__('Categories')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $category["name"]]),
    'category' => 'support-help.support.categories',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $category["name"]]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/support/categories" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.support.categories.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.support.categories.update', ['id' => $category['id']]) ?>" method="post" class="grid gap-4">
		    <div class="card p-6 mt-10">
            <?php _method('PATCH'); ?>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name', $category['name']) ?>" type="text" id="name" name="name" class="form-control">
            </div>
		    </div>
	    
	    <div class="card" x-data="tab('permissions')">
		    <div class="tab-container !flex-row !p-4 mb-2">
			    <div @click="openTab('permissions')" :class="{'active':activeTab==='permissions'}" class="tab-item">
				    <?php e__('Permissions') ?>
			    </div>
			    <div @click="openTab('fields')" :class="{'active':activeTab==='fields'}" class="tab-item">
				    <?php e__('Custom Fields') ?>
			    </div>
		    </div>
		    <div class="p-6 pt-0">
			    <div x-show="activeTab === 'permissions'" class="grid gap-4">
				    <table id="supportPermissions" class="table">
					    <thead class="">
					    <tr class="table-header">
						    <th scope="col" class="text-left">
							    <?php e__("Role") ?>
						    </th>
						    <?php foreach ($permissions as $permission): ?>
							    <th class="!font-normal"><?php e__($permission["description"]) ?></th>
						    <?php endforeach; ?>
					    </tr>
					    </thead>
					    <tbody class="divide-y divide-gray-200/20 text-center">
					    <?php foreach ($roles as $role): ?>
						    <tr>
							    <td class="text-left">
								    <div class="text-sm font-medium text-gray-800">
									    <?php echo $role['name'] ?>
								    </div>
							    </td>
							    <?php foreach ($permissions as $permission): ?>
								    <td>
									    <div class="flex justify-center">
										    <?php $this->insert('components/toggle', [
											    'name' => 'permission_' . $role["id"] . '_' . $permission["id"],
											    'default' => old(('permission_' . $role["id"] . '_' . $permission["id"]), ((in_array($role["id"], $permission["roles"]) || $role["isAdmin"]) ? '1' : '0')),
											    'disabled' => $role["isAdmin"],
										    ]); ?>
									    </div>
								    </td>
							    <?php endforeach; ?>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    
			    <div x-show="activeTab === 'fields'" class="grid gap-4">
				    <?php
					    $defaultInputs = array_map(function($supportField, $supportFieldType, $supportFieldVariables) {
						    return [
							    'supportField' => $supportField,
							    'supportFieldType' => $supportFieldType,
							    'supportFieldVariables' => $supportFieldVariables
						    ];
					    }, old('supportField', array_column($category["customFields"], 'field')), old('supportFieldType', array_column($category["customFields"], 'type')), old('supportFieldVariables', array_column($category["customFields"], 'variables')));
				    ?>
				    <div x-data="inputArray({
                    supportField: '',
                    supportFieldType: '',
                    supportFieldVariables: ''
                  }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
				    >
					    <table class="table">
						    <colgroup>
							    <col style="width: 40%;">
							    <col style="width: 20%;">
							    <col style="width: 40%;">
						    </colgroup>
						    <thead class="">
						    <tr class="table-header">
							    <th scope="col" class="!text-left !font-normal">
								    <?php e__('Fields') ?>
							    </th>
							    <th scope="col" class="!text-left !font-normal">
								    <?php e__('Type') ?>
							    </th>
							    <th scope="col" class="!text-left !font-normal">
								    <?php e__('Variables') ?>
							    </th>
							    <th scope="col">
								    <span @click="addInput()" class="btn btn-s btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
									    <i data-feather="add" class="w-4 h-4 -ml-1"></i>
									    <?php e__('Add') ?>
								    </span>
							    </th>
						    </tr>
						    </thead>
						    <tbody class="divide-y divide-gray-200/20 text-center">
						    <template x-for="(input, index) in inputs" :key="index">
							    <tr>
								    <td class="!text-left !pl-0">
									    <input type="text" class="form-control" name="supportField[]" x-bind:value="input.supportField">
								    </td>
								    <td class="!text-left !pl-0">
									    <select name="supportFieldType[]" class="form-control" x-model="input.supportFieldType">
										    <option value="1" :selected="input.supportFieldType === '1'"><?php e__("Short Text")?></option>
										    <option value="2" :selected="input.supportFieldType === '2'"><?php e__("Long Text")?></option>
										    <option value="3" :selected="input.supportFieldType === '3'"><?php e__("Single-Select")?></option>
										    <option value="4" :selected="input.supportFieldType === '4'"><?php e__("Multi-Select")?></option>
									    </select>
								    </td>
								    <td class="!text-left !pl-0">
									    <span x-show="input.supportFieldType !== '3' && input.supportFieldType !== '4'">-</span>
									    <input x-show="input.supportFieldType === '3' || input.supportFieldType === '4'" type="text" class="form-control" name="supportFieldVariables[]" x-bind:value="input.supportFieldVariables">
								    </td>
								    <td class="justify-end flex items-center">
									    <div @click="deleteInput(index)" class="btn btn-sheer btn-danger">
										    <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
									    </div>
								    </td>
							    </tr>
						    </template>
						    </tbody>
					    </table>
				    </div>
			    </div>
		    </div>
	    </div>
	    
		    <div class="flex justify-end">
			    <?php _csrf(); ?>
			    <button type="submit" class="btn btn-success">
				    <?php e__('Save Changes') ?>
			    </button>
		    </div>
    </form>
</section>

