<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.support.tickets.index',
        'text' => t__('Support')
    ],
    [
        'url' => 'dashboard.support.quick-answers.index',
        'text' => t__('Quick Answers')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Quick Answer'),
    'category' => 'support-help.support.quick-answers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container grid grid-cols-1">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Create Quick Answer') ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/support/quick-answers" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.support.quick-answers.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10 grid-cols-1 grid">
        <form action="<?php echo url('dashboard.support.quick-answers.create') ?>" method="post" class="grid grid-cols-1 gap-3">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content"><?php _old('content') ?></textarea>
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" name="insertSupportAnswers" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>

