<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.support.tickets.index',
        'text' => t__('Support')
    ],
    [
        'url' => 'dashboard.support.quick-answers.index',
        'text' => t__('Quick Answers')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $supportAnswer["title"]]),
    'category' => 'support-help.support.quick-answers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $supportAnswer["title"]]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/support/quick-answers" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.support.quick-answers.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.support.quick-answers.update', ['id' => $supportAnswer['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title', $supportAnswer['title']) ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content"><?php _old('content', $supportAnswer['content']) ?></textarea>
                </div>
            </div>
            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" name="insertSupportAnswers" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

