<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.support.tickets.index',
        'text' => t__('Support')
    ],
    [
        'text' => t__('Tickets'),
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Support Tickets'),
    'category' => 'support-help.support.tickets',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php
	$currentFilters = [
		'category' => get('category'),
		'status' => get('status')
	];
	$currentFilters = array_filter($currentFilters);
?>

<section class="los-container py-9">
    <?php if (count($tickets) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Support Tickets') ?>
            </h1>
		        <div class="flex gap-2">
			        <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/support/tickets" class="btn btn-dark" target="_blank">
				        <?php e__('Help') ?>
			        </a>
		        </div>
        </div>
	    
		    <div class="grid mt-10" x-data="table()">
			    <div class="los-table-actions mb-4 !grid grid-cols-12">
				    <div class="col-span-4">
					    <form method="get" action="<?php echo url('dashboard.support.tickets.index') ?>" class="w-full">
						    <label for="search" class="form-label">
							    <?php e__('Search for %text%', ['%text%' => t__('Support Tickets')]) ?>
						    </label>
						    <div class="input-absolute-group">
							    <i data-feather="search-normal"></i>
							    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
						    </div>
					    </form>
				    </div>
				    <div class="col-span-3">
					    <label class="form-label">
						    <?php e__('Category') ?>
					    </label>
					    <div x-data="dropdown()" class="relative">
						    <div @click="toggle()" class="btn btn-sm btn-input">
							    <span x-text="selected"></span>
							    <i data-feather="arrow-down" class="w-4 h-4"></i>
						    </div>
						    <div x-bind="isDropdown" class="dropdown w-full max-h-72 !overflow-y-auto">
							    <?php array_unshift($categories, [
								    'id' => null,
								    'name' => t__('Show All')
							    ]); ?>
							    <?php foreach ($categories as $category): ?>
								    <?php $categoryFilters = array_merge($currentFilters, ['category' => $category["id"]]); ?>
								    <a href="?<?php echo http_build_query($categoryFilters) ?>" class="<?php _active(get('category') == $category["id"]); ?>">
									    <?php echo $category["name"] ?>
								    </a>
							    <?php endforeach; ?>
						    </div>
					    </div>
				    </div>
				    <div class="col-span-3">
					    <label class="form-label">
						    <?php e__('Status') ?>
					    </label>
					    <div x-data="dropdown()" class="relative">
						    <div @click="toggle()" class="btn btn-sm btn-input">
							    <span x-text="selected"></span>
							    <i data-feather="arrow-down" class="w-4 h-4"></i>
						    </div>
						    
						    <div x-bind="isDropdown" class="dropdown w-full">
							    <?php
								    $statuses = [
											'Show All' => null,
											'Waiting Replies' => 'waiting',
                      'Answered' => 'answered',
                      'Closed' => 'closed'
								    ]
							    ?>
							    <?php foreach ($statuses as $status => $statusID): ?>
							      <?php $statusFilters = array_merge($currentFilters, ['status' => $statusID]); ?>
								    <a href="?<?php echo http_build_query($statusFilters) ?>" class="<?php _active(get('status') == $statusID); ?>">
									    <?php e__($status) ?>
								    </a>
							    <?php endforeach; ?>
						    </div>
					    </div>
				    </div>
				    <div class="col-span-2">
					    <label class="form-label">
						    <?php e__('Delete') ?>
					    </label>
					    <div x-bind="removeRequest" :class="[selects.length === 0 ? 'bg-gray-500/10 text-gray-500':'bg-red-500/10 text-red-500']" class="transition-all cursor-pointer py-3 px-4 rounded-xl text-sm">
						    <span x-show="selects.length === 0">
							    <?php e__('None Selected') ?>
						    </span>
						    <span x-show="selects.length > 0">
							    <?php e__('Delete Selected') ?>
						    </span>
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table x-ref="table">
					    <thead>
					    <tr>
						    <th scope="col" style="width: 40px">
							    <label>
								    <input x-bind="toggle" type="checkbox" class="form-checkbox">
							    </label>
						    </th>
						    <th>
							    <?php e__('Title') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Category') ?>
						    </th>
						    <th>
							    <?php e__('Status') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($tickets as $ticket): ?>
						    <tr>
							    <td>
								    <label>
									    <input x-model="selects" value="<?php echo $ticket['id'] ?>" type="checkbox" class="form-checkbox">
								    </label>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.support.tickets.show', ['id' => $ticket['id']]) ?>"><?php echo $ticket['title'] ?></a>
								    <div>#<?php echo $ticket['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $ticket['accountID']]) ?>">
									    <?php echo $ticket['realname'] ?>
								    </a>
							      <div>@<?php echo $ticket['username'] ?></div>
							    </td>
							    <td>
								    <?php echo $ticket['categoryName'] ?>
							    </td>
							    <td class="not">
								    <?php if ($ticket["statusID"] == 1): ?>
									    <span class="badge badge-primary"><?php e__('Open') ?></span>
								    <?php elseif ($ticket["statusID"] == 2): ?>
									    <span class="badge badge-success"><?php e__('Answered') ?></span>
								    <?php elseif ($ticket["statusID"] == 3): ?>
									    <span class="badge badge-warning"><?php e__('User-Reply') ?></span>
								    <?php elseif ($ticket["statusID"] == 4): ?>
									    <span class="badge badge-danger"><?php e__('Closed') ?></span>
								    <?php else: ?>
									    <span class="badge badge-danger"><?php e__('Error!') ?></span>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($ticket["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($ticket["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.support.tickets.show', ['id' => $ticket['id']]) ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <?php if (auth()->user()->canManageSupportCategory('CLOSE_TICKETS', $ticket["categoryID"])): ?>
									    <form action="<?php echo url('dashboard.support.tickets.close', ['id' => $ticket['id']]) ?>" method="post">
										    <?php _method('PATCH'); ?>
										    <?php _csrf(); ?>
										    <button x-bind="tooltip('<?php e__('Close') ?>')" type="submit" class="btn btn-sm btn-icon btn-warning">
											    <i class="stroke-white stroke-2 w-4" data-feather="close"></i>
										    </button>
									    </form>
								    <?php endif; ?>
								    <?php if (auth()->user()->canManageSupportCategory('DELETE_TICKETS', $ticket["categoryID"])): ?>
									    <form action="<?php echo url('dashboard.support.tickets.destroy', ['id' => $ticket['id']]) ?>" method="post" x-data="deleteConfirmation()">
										    <?php _method('DELETE'); ?>
										    <?php _csrf(); ?>
										    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
											    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
										    </button>
									    </form>
								    <?php endif; ?>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No tickets found!'),
            'details' => t__('There are no tickets to show you right now.'),
        ]);
    endif; ?>
</section>
