<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.support.tickets.index',
        'text' => t__('Support')
    ],
    [
        'url' => 'dashboard.support.tickets.index',
        'text' => t__('Tickets')
    ],
    [
        'text' => t__('View')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('View Ticket'),
    'category' => 'support-help.support.tickets',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('scripts') ?>
<script src="<?php echo $this->asset('/js/support-quick-answer.js') ?>"></script>
<script>
    $(document).ready(function () {
        var element = $("#messagesBox");
        element.scrollTop(element.prop("scrollHeight"));
    });
</script>
<?php $this->end() ?>

<section class="los-container">
    <div class="los-page-heading">
      <h1 class="text-gray-950">
        <?php echo $support["title"] ?>
      </h1>
	    <div class="flex gap-2">
		    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/support/tickets" class="btn btn-dark" target="_blank">
			    <?php e__('Help') ?>
		    </a>
	      <a href="<?php echo url('dashboard.support.tickets.index') ?>" class="btn btn-default">
          <?php e__('Back') ?>
	      </a>
	    </div>
    </div>
	
	<div class="mt-10 mb-32 grid grid-cols-1 lg:grid-cols-7 gap-4">
		<div class="lg:col-span-2 flex flex-col gap-4">
			<div class="card">
				<div class="py-4 px-5">
					<h5 class="card-title">
						<?php e__('Details') ?>
					</h5>
					
					<div class="py-3 grid gap-2">
						<div class="bg-gray-50 rounded-xl py-2 px-3 divide-y divide-gray-600/5">
							<div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
								<span class="text-sm"><?php e__('Opened by') ?>:</span>
								<div class="text-right">
									<a href="<?php echo url('dashboard.accounts.show', ['id' => $support['accountID']]) ?>" class="text-sm font-normal text-gray-700">
										<?php echo $support['realname'] ?>
									</a>
									<div class="text-xs text-gray-500">
										@<?php echo $support["username"] ?>
									</div>
								</div>
							</div>
							<div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
								<span class="text-sm"><?php e__('Category') ?>:</span>
								<span class="text-sm font-normal text-gray-500 text-right">
									<?php echo $support['categoryName'] ?>
								</span>
							</div>
							<div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
								<span class="text-sm"><?php e__('Status') ?>:</span>
								<span class="text-sm font-normal text-gray-500 text-right">
									<?php switch ($support["statusID"]) {
										case 1:
											$status = t__('Open');
											$class = 'text-blue-500';
											break;
										case 2:
											$status = t__('Answered');
											$class = 'text-emerald-500';
											break;
										case 3:
											$status = t__('User-Reply');
											$class = 'text-yellow-500';
											break;
										default:
											$status = t__('Closed');
											$class = 'text-red-500';
											break;
									} ?>
									<span class="<?php echo $class ?>">
										<?php echo $status ?>
									</span>
								</span>
							</div>
							<div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
								<span class="text-sm"><?php e__('Last Updated') ?>:</span>
								<span class="text-sm font-normal text-gray-500 text-right">
									<?php echo convertTime($support["updateDate"], 2, true) ?>
									<div class="text-xs text-gray-400"><?php echo convertTime($support["updateDate"]) ?></div>
								</span>
							</div>
							<div class="flex justify-between items-center text-gray-700 font-medium gap-6 py-2">
								<span class="text-sm"><?php e__('Date') ?>:</span>
								<span class="text-sm font-normal text-gray-500 text-right">
									<?php echo convertTime($support["creationDate"], 2, true) ?>
									<div class="text-xs text-gray-400"><?php echo convertTime($support["creationDate"]) ?></div>
								</span>
							</div>
						</div>
					</div>
					
					<?php if (count($supportFieldValues) > 0): ?>
						<div class="pb-3 grid gap-2">
							<div class="bg-gray-50 rounded-xl py-2 px-3 divide-y divide-gray-600/5">
								<?php foreach ($supportFieldValues as $supportFieldValue): ?>
									<div class="text-gray-700 font-medium py-2">
										<div class="text-sm"><?php echo $supportFieldValue["field"] ?>:</div>
										<div class="text-sm font-normal text-gray-500 mt-0.5">
											<?php echo $supportFieldValue["value"] ?>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
			
			
			<?php if (
				auth()->user()->canManageSupportCategory('DELETE_TICKETS', $support["categoryID"]) ||
				auth()->user()->canManageSupportCategory('CLOSE_TICKETS', $support["categoryID"])
			): ?>
				<div class="card py-8 px-5 text-center">
					<h5 class="card-title !text-base">
						<?php e__('Take action on this ticket') ?>
					</h5>
					<div class="flex justify-center gap-2 mt-4">
						<?php if (auth()->user()->canManageSupportCategory('DELETE_TICKETS', $support["categoryID"])): ?>
							<form action="<?php echo url('dashboard.support.tickets.destroy', ['id' => $support["id"]]) ?>" method="post" data-submit-loading>
								<?php _method('DELETE') ?>
								<button type="submit" class="btn btn-danger flex items-center gap-2">
									<i class="store-white stroke-2 w-4" data-feather="trash"></i>
									<?php e__('Delete') ?>
								</button>
								<?php _csrf(); ?>
							</form>
						<?php endif; ?>
						
						<?php if (auth()->user()->canManageSupportCategory('CLOSE_TICKETS', $support["categoryID"])): ?>
							<form action="<?php echo url('dashboard.support.tickets.close', ['id' => $support["id"]]) ?>" method="post" data-submit-loading>
								<?php _method('PATCH') ?>
								<button type="submit" class="btn btn-warning flex items-center gap-2">
									<i class="store-white stroke-2 w-4" data-feather="close"></i>
									<?php e__('Close') ?>
								</button>
								<?php _csrf(); ?>
							</form>
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>
		</div>
		<div class="lg:col-span-5 flex flex-col gap-8">
			<div class="card">
				<div id="messagesBox" class="max-h-[500px] overflow-y-auto mt-4">
					<?php foreach ($supportMessages as $supportMessage): ?>
						<div
							x-data="{isStaff: <?php echo $supportMessage["writeLocation"] == '1' ? 'false' : 'true' ?>}"
							class="flex flex-col gap-2 md:flex-row justify-between px-8 py-4 transition hover:bg-gray-50"
							:class="isStaff && 'bg-gray-50'"
						>
							<div class="flex items-start gap-4 w-full">
								<a href="<?php echo url('dashboard.accounts.show', ['id' => $supportMessage['accountID']]) ?>">
									<?php $this->insert('components/avatar', [
										'avatar' => $supportMessage['avatar'],
										'username' => $supportMessage['realname'],
										'class' => 'rounded-lg',
										'size' => '40px'
									]); ?>
								</a>
								<div class="w-full">
									<div class="">
										<a href="<?php echo url('dashboard.accounts.show', ['id' => $supportMessage['accountID']]) ?>" class="font-medium text-gray-800 mr-1.5"><?php echo $supportMessage["realname"]; ?></a>
										<span class="text-xs text-gray-400/75"><?php echo convertTime($supportMessage["creationDate"]) ?></span>
									</div>
									<div class="text-sm text-gray-500 mt-2"><?php echo $supportMessage["message"] ?></div>
								</div>
							</div>
							<div class="ml-auto">
								<form action="<?php echo url('dashboard.support.tickets.messages.destroy', ['id' => $supportMessage["id"]]) ?>" method="post" x-data="deleteConfirmation()">
									<?php _method('DELETE'); ?>
									<button type="submit" x-bind="tooltip('<?php e__('Delete Message') ?>')">
										<i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
									</button>
									<?php _csrf(); ?>
								</form>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
				<hr>
				<div class="px-5 mt-4">
					<select x-data="select2Alpine()" name="quick_reply" data-edit id="selectAnswer">
						<?php if (count($supportAnswers) > 0): ?>
							<option value="">
								<?php e__('You can choose a quick reply.') ?>
							</option>
							<?php foreach ($supportAnswers as $supportAnswer): ?>
								<option value="<?php echo htmlentities($supportAnswer["content"]); ?>"><?php echo $supportAnswer["title"]; ?></option>
							<?php endforeach; ?>
						<?php else: ?>
							<option value="">
								<?php e__('No quick reply found!') ?>
							</option>
						<?php endif; ?>
					</select>
				</div>
				<div class="mb-4 px-5">
					<form action="<?php echo url('dashboard.support.tickets.messages.store', ['id' => $support['id']]) ?>" method="post" data-submit-loading>
						<div x-data="textEditor()" class="mt-4 dark-theme">
							<textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" id="textareaMessage" name="message"><?php _old('message'); ?></textarea>
						</div>
						<div class="flex justify-end mt-3">
							<?php _csrf(); ?>
							<button name="insertSupportMessages" type="submit" class="btn btn-success">
								<?php e__('Send') ?>
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</section>
