<?php
$breadcrumbs = [
    [
        'text' => t__('Tebex Store')
    ],
    [
        'text' => t__('Settings')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Tebex Store Settings'),
    'category' => 'tebex-store.settings',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Tebex Store Settings') ?></h1>
        <div class="flex gap-2">
	        <a href="<?php echo leaderosHelpUrl() ?>/integrations/tebex-store" class="btn btn-dark" target="_blank">
            <?php e__('Help') ?>
          </a>
        </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.tebex-store.settings.update') ?>" method="post" class="grid gap-4">
        <?php _method('PATCH'); ?>
        <?php _csrf(); ?>
        <div class="mt-10 card p-6 grid gap-4">
            <div>
                <label for="publicKey" class="form-label">Public Token:</label>
                <div>
                    <input type="text" id="publicKey" class="form-control" name="publicKey" value="<?php _old('publicKey', moduleSettings('tebex_store', 'publicKey')); ?>">
                </div>
            </div>
            <div>
              <label for="secretKey" class="form-label">Webhook Secret Key:</label>
              <div>
                <input type="text" id="secretKey" class="form-control" name="secretKey" value="<?php _old('secretKey', moduleSettings('tebex_store', 'secretKey')); ?>">
              </div>
            </div>
        </div>
        <div class="flex justify-end gap-2">
            <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
        </div>
    </form>
</section>